// -*- C++ -*-
// Inode handling class
//
// This program is distributed under the terms of the
// Free Software Foundation General Public Licence.
// Copyright Jeremy Fitzhardinge <jeremy@sw.oz.au> 1993

#pragma implementation

#include "Inode.h"
#include "Filesystem.h"

#include <stdio.h>

InodeList::InodeList()
{
	list = NULL;
}

InodeList::~InodeList()
{
	Inode *next;

	for(next = list; next != NULL; next = next->next)
		next->cleanup();
	
	for(; list != NULL; list = next)
	{
		next = list->next;
		delete list;
	}
}

void
InodeList::add(Inode *ino)
{
	if (ino->onlist)
	{
		fprintf(stderr, "Adding %p onto list again\n", ino);
		return;
	}
	ino->next = list;
	ino->prev = NULL;
	if (ino->next)
		ino->next->prev = ino;
	list = ino;
	ino->onlist = 1;
}

void
InodeList::del(Inode *ino)
{
	if (!ino->onlist)
		return;
	if (ino->prev)
		ino->prev->next = ino->next;
	else
		list = ino->next;
	if (ino->next)
		ino->next->prev = ino->prev;
	ino->onlist = 0;
}

Inode *
InodeList::find(Handle hand)
{
	Inode *ino;

	for(ino = list; ino != NULL; ino = ino->next)
		if (ino->handle == hand)
			break;

	if (ino == NULL)
		return NULL;

	// Move to head of list
	del(ino);
	add(ino);

	return ino;
}

Inode::Inode(Filesystem &fs, Handle hand)
      :next(NULL),prev(NULL),nlink(0),handle(hand),filesys(fs)
{
	alive = 1;
	onlist = 0;
	filesys.inodes.add(this);
}

Inode::~Inode()
{
	if (!alive)
		fprintf(stderr, "Inode %p already dead!\n", this);
	filesys.inodes.del(this);
	alive = 0;
}

Inode *
Inode::findino(Handle h)
{
	return filesys.inodes.find(h);
}

#if 0
void
Inode::iread(up_inode &ino)
{
	ino.uid = uid;
	ino.gid = gid;
	ino.mode = mode;
	ino.nlink = nlink;
	ino.mtime = mtime;
	ino.ctime = ctime;
	ino.atime = atime;
	ino.size = size;
}
#endif

#define DO(op)	 int Inode::do_##op(const up_preamble &, upp_repl &) { return ENOSYS; }
#define DOa(op)	 int Inode::do_##op(const up_preamble &, upp_repl &, const upp_##op##_s &) { return ENOSYS; }
#define DOr(op)	 int Inode::do_##op(const up_preamble &, upp_repl &, upp_##op##_r &) { return ENOSYS; }
#define DOar(op) int Inode::do_##op(const up_preamble &, upp_repl &, const upp_##op##_s &, upp_##op##_r &) { return ENOSYS; }
#define opFILE
#define opINODE
#include "operations.h"

