// -*- c++ -*-
//
// User level filesystem class
//
// This program is distributed under the terms of the
// Free Software Foundation General Public Licence.
// Copyright Jeremy Fitzhardinge <jeremy@sw.oz.au> 1993

#pragma implementation

#include "Filesystem.h"
#include <unistd.h>
#include "dbg.h"

Filesystem::Filesystem(const char *mp)
{
	mpoint = mp;
	rootdir = (Handle)-1;
}

Filesystem::~Filesystem()
{
}

#include <stdio.h>
#define check(v1, op, v2)								\
	{										\
		int eq_ = ((v1) op (v2));						\
		if (!eq_)								\
		{									\
			fprintf(stderr, "Check failed :"#v1"(%d)"#op#v2"(%d)\n",	\
				(v1), (v2));						\
		}									\
	}

static void genrepl(const up_preamble &pre, upp_repl &repl)
{
	repl.size = 0;
	repl.errno = 0;
	repl.isreq = UP_REPL;
	repl.seq = pre.seq;
	repl.op = pre.op;
	repl.version = UP_VERSION;
}

int
Filesystem::DoOp(const up_preamble &pre, upp_repl &repl, Data *data)
{
	int err;
	
	LOG("DoOp");
	check(pre.isreq == UP_ENQ, ||, pre.isreq == UP_REQ);
	check(pre.version, ==, UP_VERSION); 

	genrepl(pre, repl);

	if (pre.isreq == UP_ENQ)
	{
		repl.errno = Enquire((up_ops)pre.op);
		return 1;
	}

	switch(pre.op)
	{
		// Macros to generate calls to methods
#define DO(op)	\
	case up_##op:\
		LOG("Doing" #op);\
	 	err = do_##op(pre, repl);\
		break;
#define DOa(op) \
	case up_##op:\
	{\
		LOG("Doing " #op);\
	 	upp_##op##_s arg;\
		decode_upp_##op##_s(&arg, data);\
		err = do_##op(pre, repl, arg);\
		break;\
	}
#define DOr(op) \
	case up_##op:\
	{\
		LOG("Doing " #op);\
	 	upp_##op##_r ret;\
		err = do_##op(pre, repl, ret);\
		if (!err) repl.size = encode_upp_##op##_r(&ret, data) - data;\
		break;\
	}
#define DOar(op) \
	case up_##op:\
	{\
		LOG("Doing " #op);\
	 	upp_##op##_s arg;\
	 	upp_##op##_r ret;\
		decode_upp_##op##_s(&arg, data);\
		err = do_##op(pre, repl, arg, ret);\
		if (!err) repl.size = encode_upp_##op##_r(&ret, data) - data;\
		break;\
	}
#include "operations.h"
		
	default:
		err = ENOSYS;
		break;
	}

	if (err == -1)
		return -1;
	
	if (err != 0)
	{
		check(repl.size, ==, 0);
		repl.size = 0;
		repl.errno = err;
	}

	return 1;
}

int
Filesystem::Enquire(up_ops)
{
	return ENOSYS;
}

#define DO(op)	 int Filesystem::do_##op(const up_preamble &, upp_repl &) { return ENOSYS; }
#define DOa(op)	 int Filesystem::do_##op(const up_preamble &, upp_repl &, const upp_##op##_s &) { return ENOSYS; }
#define DOr(op)	 int Filesystem::do_##op(const up_preamble &, upp_repl &, upp_##op##_r &) { return ENOSYS; }
#define DOar(op) int Filesystem::do_##op(const up_preamble &, upp_repl &, const upp_##op##_s &, upp_##op##_r &) { return ENOSYS; }
#define opSUPER
#include "operations.h"

// The rest of the operations are methods of an Inode
#define DOa(op, elem)	\
	int Filesystem::do_##op(const up_preamble &pre, upp_repl &repl,\
				const upp_##op##_s &arg) \
	{\
	LOG("Doa_"#op); \
	 	Inode *ino = inodes.find(arg.elem.handle);\
	 	if (ino == NULL)\
			return EINVAL;\
		ino->beforeop(up_##op);\
		int ret = ino->do_##op(pre, repl, arg);\
		ino->afterop(up_##op);\
		return ret;\
	}
#define DOar(op, elem)	\
	int Filesystem::do_##op(const up_preamble &pre, upp_repl &repl,\
				const upp_##op##_s &arg, upp_##op##_r &ret) \
	{\
	LOG("Doar_"#op); \
	 	Inode *ino = inodes.find(arg.elem.handle);\
	 	if (ino == NULL)\
			return EINVAL;\
		ino->beforeop(up_##op);\
		int r = ino->do_##op(pre, repl, arg, ret);\
		ino->afterop(up_##op);\
		return r;\
	}

DOar(create, dir);
DOar(lookup, dir);
DOa(link, dir);
DOa(unlink, dir);
DOa(symlink, dir);
DOa(rename, odir);
DOar(readlink, link);
DOar(followlink, link);
DOa(permission, file);
DOa(iwrite, handle);
DOar(iread, handle);
DOa(notify_change, handle);
DOa(iput, handle);

DOar(read, file);
DOar(write, file);
DOar(readdir, dir);
DOar(multireaddir, dir);
DOar(open, file);
DOa(close, file);
DOa(truncate, file);
