/*
 * Handling for loadable module
 */

#include <linux/module.h>
#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/userfs_types.h>
#include <linux/userfs_fs_sb.h>

#ifdef MODULE
#include <linux/module.h>
#include <linux/version.h>

static char kernel_version[] = UTS_RELEASE;

static struct file_system_type ufst = { userfs_read_super, "userfs", 0, NULL };

int init_module(void)
{
	int err;
	err = register_filesystem(&ufst);

	if (err)
	{
		printk("userfs: failed to register filesystem\n");
		return err;
	}

	return 0;
}

void cleanup_module(void)
{
	int err;
	if (MOD_IN_USE)
		printk("userfs: filesystem in use, removal delayed\n");


	if (err = unregister_filesystem(&ufst))
	{
		printk("userfs: failed to unregister filesystem\n");
		return;
	}
}

#endif
