/*
 *	Information passed from user process to the kernel as the
 *	3rd argument to mount(2).
 */

#ifndef _LINUX_USERFS_MOUNT
#define _LINUX_USERFS_MOUNT

/*
 * WARNING!  Do not delete or change the order of these fields.  If
 * a new field is required then add it to the end.  The version field
 * tracks which fields are present.  This will ensure some measure of
 * mount-to-kernel version compatibilty.  Some of these aren't used yet
 * but here they are anyway.
 */

/* Change this if things are added to the structure below */
#define USERFS_VERSION 	3


struct userfs_mount
{
	int	version;	/* v1 - version of structure */
	int	tokern;		/* v1 - fd of stream into the kernel */
	int	fromkern;	/* v1 - from kernel */
	int	magic;		/* v2 - magic */
	int	seq;		/* v3 - initial sequence number */
};

#endif /* _LINUX_USERFS_MOUNT */
