# include	<stdio.h>
# include	<malloc.h>
# include	"oskfs.h"

fdes *
read_fdes (ulong lsn)
{
	if (read_cache (lsn, 0, sector, secsize) != secsize)
		return (NULL);
	return (osk2fdes (sector));
}

TBuffer *
read_part (fdes *fd, ulong off, size_t siz)
{
	static TBuffer	tb;
	static unchar	*data = NULL;
	static int	dsiz = 0;
	unchar		*ptr;
	ulong		offset;
	ulong		fsize;
	int		cnt, cur;
	int		seg;
	fseg		*fs;

	if (off >= fd -> size)
		return (NULL);
	if (off + siz > fd -> size)
		siz = fd -> size - off;
	if (siz >= dsiz) {
		dsiz = siz;
		if (! (data = realloc (data, (dsiz + 4) * sizeof (unchar)))) {
			dsiz = 0;
			return (NULL);
		}
	}
	seg = 0;
	fsize = fd -> size;
	while (seg < fsegsize) {
		fs = & fd -> fs[seg];
		offset = fs -> bcnt * secsize;
		if (offset < off) {
			off -= offset;
			if (fsize < offset)
				return (NULL);
			fsize -= offset;
			if (++seg >= fsegsize)
				return (NULL);
		} else
			break;
	}
	ptr = data;
	cnt = 0;
	while (cnt < siz) {
		if (seg >= fsegsize)
			return (NULL);
		if (! (cur = fd -> fs[seg].bcnt * secsize))
			return (NULL);
		else if (cur > fsize)
			cur = fsize;
		cur -= off;
		if (cur > siz - cnt)
			cur = siz - cnt;
		if (read_cache (fd -> fs[seg].lsn, off, ptr, cur) != cur)
			return (NULL);
		off = 0;
		cnt += cur;
		ptr += cur;
		++seg;
	}
	tb.ptr = data;
	tb.size = siz;
	return (& tb);
}

