# include	<stdio.h>
# include	<time.h>
# include	<string.h>
# include	<malloc.h>
# include	<sys/stat.h>
# include	"oskfs.h"

# define	conv1(xxx)	((ulong) (xxx)[0])
# define	conv2(xxx)	((ulong) (((xxx)[0] << 8) |	\
					  ((xxx)[1])))
# define	conv3(xxx)	((ulong) (((xxx)[0] << 16) |	\
					  ((xxx)[1] << 8) |	\
					  ((xxx)[2])))
# define	conv4(xxx)	((ulong) (((xxx)[0] << 24) |	\
					  ((xxx)[1] << 16) |	\
					  ((xxx)[2] << 8) |	\
					  ((xxx)[3])))

time_t
osk2time (unchar *ptr)
{
	struct tm	tt;
	time_t		ret;

	memset (& tt, 0, sizeof (tt));
	tt.tm_year = ptr[0];
	tt.tm_mon = ptr[1];
	tt.tm_mday = ptr[2];
	tt.tm_hour = ptr[3];
	tt.tm_min = ptr[4];
	ret = mktime (& tt);
# if	0
	if (ret < 0)
		printf ("osk2time: Y=%d, M=%d, D=%d, H=%d, M=%d\n",
			(int) ptr[0],
			(int) ptr[1],
			(int) ptr[2],
			(int) ptr[3],
			(int) ptr[4]);
# endif
	return (ret);
}

mode_t
osk2mode (unchar *md)
{
	mode_t	mode;

	if (*md & (1 << 7))
		mode = S_IFDIR;
	else
		mode = S_IFREG;
	if (*md & (1 << 5))
		mode |= S_IXOTH;
	if (*md & (1 << 4))
		mode |= S_IWOTH;
	if (*md & (1 << 3))
		mode |= S_IROTH;
	if (*md & (1 << 2))
		mode |= S_IXGRP | S_IXUSR;
	if (*md & (1 << 1))
		mode |= S_IWGRP | S_IWUSR;
	if (*md & (1 << 0))
		mode |= S_IRGRP | S_IRUSR;
	return (mode);
}

lsn0 *
osk2lsn0 (unchar *sec)
{
	static lsn0	l0;
	char		*ptr;
	int		n;

	l0.sects = conv3 (sec);		sec += 3;
	l0.tsize = conv1 (sec);		sec += 1;
	l0.amap = conv2 (sec);		sec += 2;
	l0.csize = conv2 (sec);		sec += 2;
	l0.rootdir = conv3 (sec);	sec += 3;
	l0.uid = conv2 (sec);		sec += 2;
	l0.gid = l0.uid >> 8;
	l0.uid &= 0xff;
	l0.mode = osk2mode (sec);	sec += 1;
	l0.diskid[0] = *sec++;
	l0.diskid[1] = *sec++;
	l0.dfmt = *sec++;
	l0.sectptr = conv2 (sec);	sec += 2;
	/* reserved for future use */	sec += 2;
	l0.bootlsn = conv3 (sec);	sec += 3;
	l0.bootsiz = conv2 (sec);	sec += 2;
	l0.ctime = osk2time (sec);	sec += 5;
	memcpy (l0.name, sec, 32);	sec += 32;
	ptr = l0.name;
	for (n = 0; n < 32; ++n)
		if (*ptr & 0x80) {
			*ptr++ &= 0x7f;
			break;
		} else
			++ptr;
	*ptr = '\0';
	memcpy (l0.pdo, sec, 32);	sec += 32;
	return (& l0);
}

fdes *
osk2fdes (unchar *sec)
{
	static fdes	fd;
	static Bool	isinit = False;
	unchar		tmp[5];
	int		n;

	if (isinit == False) {
		if (! (fd.fs = (fseg *) malloc (fsegsize * sizeof (fseg))))
			return (NULL);
		isinit = True;
	}
	fd.mode = osk2mode (sec);	sec += 1;
	fd.uid = conv2 (sec);		sec += 2;
	fd.gid = fd.uid >> 8;
	fd.uid &= 0xff;
	fd.mtime = osk2time (sec);	sec += 5;
	fd.nlink = conv1 (sec);		sec += 1;
	if ((fd.mode & S_IFDIR) && (fd.nlink == 1))
		fd.nlink = 2;
	fd.size = conv4 (sec);		sec += 4;
	memcpy (tmp, sec, 3);		sec += 3;
	tmp[3] = 0;
	tmp[4] = 0;
	fd.ctime = osk2time (tmp);
	for (n = 0; n < fsegsize; ++n) {
		fd.fs[n].lsn = conv3 (sec);	sec += 3;
		fd.fs[n].bcnt = conv2 (sec);	sec += 2;
	}
	return (& fd);
}

directory *
osk2directory (unchar *dr)
{
	static directory	dir;
	char			*ptr;
	int			n;

	memcpy (dir.name, dr, 28);	dr += 28;
	ptr = dir.name;
	for (n = 0; n < 28; ++n)
		if (*ptr & 0x80) {
			*ptr++ &= 0x7f;
			break;
		} else
			++ptr;
	*ptr = '\0';
	dr += 1;
	dir.lsn = conv3 (dr);
	return (& dir);
}
