# include	<stdio.h>
# include	<stdlib.h>
# include	<unistd.h>
# include	<signal.h>
# include	<string.h>
# include	<malloc.h>
# include	<sys/stat.h>
# include	<tar.h>
# include	"fslib.h"
# include	"zipfs.h"

# define	TGZ_GET_CMD		"gunzip -c"

typedef struct _tarpos {
	char	*fname;
	ulong	size;
	ulong	start;
	struct _tarpos
		*next;
}	tarpos;

static char	*zfname = NULL;
static Bool	first = True;
static tarpos	*tpr = NULL,
		*tprev = NULL;
static ulong	cblock = 0;

static char *
tgz_get (Inode *I, Bool *isdir)
{
	static FILE	*pp;
	char		*tmp;
	tarpos		*ttmp;
	int		n, cnt;
	char		buf[520];
	static char	fbuf[256];

	if (first) {
		first = False;
		if (access (zfname, R_OK) < 0)
			return (NULL);
		if (! (tmp = malloc (sizeof (TGZ_GET_CMD) + strlen (zfname) + 4)))
			return (NULL);
		sprintf (tmp, "%s '%s'", TGZ_GET_CMD, zfname);
		pp = popen (tmp, "r");
		free (tmp);
		if (! pp)
			return (NULL);
	}
	if (pp) {
		if ((fread (buf, sizeof (char), 512, pp) == 512) && buf[0]) {
			++cblock;
			sscanf (buf + 100, "%lo", (long *) & I -> mode);
			buf[100] = '\0';
			if ((tmp = strrchr (buf, '/')) && (*(tmp + 1) == '\0'))
				*tmp = '\0';
			sscanf (buf + 108, "%lo", (long *) & I -> uid);
			sscanf (buf + 116, "%lo", (long *) & I -> gid);
			sscanf (buf + 124, "%lo", (long *) & I -> size);
			sscanf (buf + 136, "%lo", (long *) & I -> mtime);
			buf[512] = '\0';
			if (buf[345] != '\0')
				sprintf (fbuf, "%s/%s", buf, buf + 345);
			else
				strcpy (fbuf, buf);
			if ((ttmp = (tarpos *) malloc (sizeof (tarpos))) && (ttmp -> fname = strdup (fbuf))) {
				ttmp -> size = I -> size;
				ttmp -> start = cblock;
				ttmp -> next = NULL;
				if (tprev)
					tprev -> next = ttmp;
				else
					tpr = ttmp;
				tprev = ttmp;
			}				
			cnt = I -> size;
			while (cnt > 0)
				if ((n = fread (buf, sizeof (char), 512, pp)) == 512) {
					++cblock;
					cnt -= n;
				} else
					break;
			if ((I -> mode & S_IFDIR) || (buf[156] == DIRTYPE)) {
				I -> mode |= S_IFDIR;
				*isdir = True;
			} else {
				I -> mode |= S_IFREG;
				*isdir = False;
			}
			return (fbuf);
		}
		while (fread (buf, sizeof (char), 512, pp) > 0)
			++cblock;
		pclose (pp);
		pp = NULL;
	}
	return (NULL);
}

static void
tgz_read (zipnfo *z)
{
	char	buf[520];
	tarpos	*t;
	char	*tmp;
	FILE	*pp;
	ulong	mov;

	for (t = tpr; t; t = t -> next)
		if (! strcmp (z -> path, t -> fname))
			break;
	if (t) {
		z -> siz = t -> size;
		if (! (z -> cont = (unchar *) realloc (z -> cont, (z -> siz + 16) * sizeof (unchar)))) {
			z -> siz = 0;
			z -> cnt = 0;
			return;
		}
		z -> cnt = t -> size;
		if (t -> size) {
			if (! (tmp = malloc (sizeof (TGZ_GET_CMD) + strlen (zfname) + 4)))
				return;
			sprintf (tmp, "%s '%s'", TGZ_GET_CMD, zfname);
			pp = popen (tmp, "r");
			free (tmp);
			if (! pp)
				return;
			mov = t -> start;
			while (mov > 0)
				if (fread (buf, sizeof (char), 512, pp) == 512)
					--mov;
				else
					break;
			if (! mov)
				fread (z -> cont, sizeof (unchar), z -> cnt, pp);
			while (fread (buf, sizeof (char), 512, pp) > 0)
				;
			pclose (pp);
		}
	}
}

static struct {
	char		*ext;
	Zipper		zp;
	zipcalls	zc;
}	avail[] = {
	{	"tgz",		ZTarGZip,
		{		tgz_get,	NULL,
				tgz_read,	NULL		}
	}
};

# define	ASIZE		(sizeof (avail) / sizeof (avail[0]))

zipcalls *
setup_zipper (char *fname)
{
	static zipcalls	zc;
	char		*ptr;
	int		n;

# if	0
	if (ptr = strchr (fname, '.'))
		++ptr;
	else
		return (NULL);
	for (n = 0; n < ASIZE; ++n)
		if (! strcasecmp (ptr, avail[n].ext))
			break;
	if (n == ASIZE)
		return (NULL);
# else
	n = 0;
# endif
	if (! (zfname = strdup (fname)))
		return (NULL);
	signal (SIGPIPE, SIG_IGN);
	signal (SIGCLD, SIG_IGN);
	zc = avail[n].zc;
	return (& zc);
}
