# include	<stdio.h>
# include	<errno.h>
# include	<malloc.h>
# include	<string.h>
# include	<time.h>
# include	<sys/stat.h>
# include	"fslib.h"

# define	FALSE		(1 == 0)
# define	TRUE		(1 == 1)

static filenam	*root;

static void
print_error (char *str)
{
	fprintf (stderr, "Color (%d): %s\n", errno, str);
}

static char	*cname[] = {
	"black",
	"red",
	"green",
	"yellow",
	"blue",
	"purple",
	"cyan",
	"white"
};

static void
alloc_colors (filenam *up, filenam *src, int offset)
{
	filenam	*base, *cur;
	int	n;
	char	tmp[32];

	base = alloc_filenam (".", src -> i, True, NULL);
	cur = base;
	cur -> next = alloc_filenam ("..", up -> i, True, NULL);
	cur = cur -> next;
	for (n = 0; n < 8; ++n) {
		sprintf (tmp, "\033[%dm", n + offset);
		cur -> next = alloc_filenam (cname[n], 0, False, strdup (tmp));
		set_filesize (cur -> next -> i, strlen (tmp));
		cur = cur -> next;
	}
}

static Status
do_init (int ac, char **av)
{
	filenam	*cur;

	root = alloc_filenam (".", 0, True, NULL);
	cur = root;
	cur -> next = alloc_filenam ("..", root -> i, True, NULL);
	cur = cur -> next;
	cur -> next = alloc_filenam ("foreground", 0, True, NULL);
	cur = cur -> next;
	alloc_colors (root, cur, 30);
	cur -> next = alloc_filenam ("background", 0, True, NULL);
	cur = cur -> next;
	alloc_colors (root, cur, 40);
	return (Ok);
}

static TBuffer *
fileread (ulong handle, off_t off, off_t size, ulong ctok)
{
	static TBuffer	tb;
	finode		*i;
	char		*ptr;
	int		msiz;

	if (! (i = get_finode (handle))) {
		errno = EBADF;
		return (NULL);
	}
	msiz = i -> ino.size - off;
	if (msiz < size)
		size = msiz;
	tb.size = size;
	ptr = i -> priv;
	tb.ptr = size ? (ptr + off) : "";
	return (& tb);
}

static ulong
do_mount (void)
{
	return (root -> i);
}

static fscalls	calls = {
	print_error,		/* errorlog */
	do_init,		/* init */
	NULL,			/* deinit */
	NULL,			/* create */
	def_lookup,		/* lookup */
	NULL,			/* close */
	fileread,		/* read */
	NULL,			/* write */
	NULL,			/* truncate */
	NULL,			/* fsync */
	def_readdir,		/* readdir */
	NULL,			/* link */
	NULL,			/* unlink */
	NULL,			/* symlink */
	NULL,			/* readlink */
	NULL,			/* followlink */
	do_mount,		/* mount */
	NULL,			/* umount */
	def_iread,		/* iread */
	NULL,			/* iwrite */
	NULL,			/* statfs */
	NULL,			/* iput */
	NULL,			/* open */
	NULL,			/* permission */
	NULL,			/* rename */
	def_multireaddir,	/* multireadddir */
	NULL			/* notify_change */
};

void
inform_user (UserInfo ui, void *ptr)
{
}

int
main (int argc, char **argv)
{
	return (userfs (argc, argv, & calls));
}
