// -*- C++ -*-

#pragma implementation

#include "maildir.h"
#include "mailfile.h"
#include "maillink.h"
#include "mailfs.h"
#include "mail.h"

#include <sys/stat.h>
#include <unistd.h>

maildir::maildir(mailfs &fs, Handle h, Inode *p, time_t t)
      : DirInode(fs, h, p)
{
 uid = getuid();
 gid = getgid();
 mode = S_IFDIR | 0555;
 ifile = NULL;
 atime = ctime = mtime = t;
}

maildir::maildir(mailfs &fs, Handle h, Inode *p, ifstream *ifile, streampos start, int l, time_t t)
      : DirInode(fs, h, p), start(start), ifile(ifile)
{
 uid = getuid();
 gid = getgid();
 mode = S_IFDIR | 0555;
 length = l;
 atime = ctime = mtime = t;
}

// This constructs the entire directory heirachy for this
// filesystem. 
mailtopdir::mailtopdir(mailfs &fs, Handle h, Inode *p)
	 : maildir(fs, h, p, time(NULL))
{
// String mailfn = getenv("MAIL");
 puts("Parsing... "); 
 mail nmail(fs.file());
 puts("done");
 int i, iform = 0;
 Pix a, b;
 String name;
 char num[16], form[16];
// DLList<message> &m;
// DLList<header> &hdr;
 DirInode *d;
 Inode *f;
 ifstream *file;
 streampos offset;
 int len, body;
 time_t tm;
 
 if(iform > 0)
  sprintf(form, "%%0%d.", iform);
 else
  strcpy(form, "%d.");
// nmail.disp();
 DLList<message> &m = nmail.contents();
 for(i = 1, a = m.first(); a != NULL; m.next(a), i++)
 {
  sprintf(num, form, i);
  name = num + m(a).name();

  m(a).report(file, offset, len, body, tm);
  d = new maildir(fs, fs.genhand(), this, file, offset, len, tm);
  link(name, d);
  f = new mailfile(fs, fs.genhand(), file, offset + body, len - body, tm);
  d->link("body.txt", f);
  f = new mailfile(fs, fs.genhand(), file, offset, len, tm);
  d->link(".complete.txt", f);

  DLList<header> &hdr = *(m(a).headers());
  for(b = hdr.first(); b != NULL; hdr.next(b))
  {
   hdr(b).report(file, offset, len);
   f = new mailfile(fs, fs.genhand(), file, offset, len, tm);
   d->link(hdr(b).name(), f);
  }
 }
 puts("MAILFS ready");

/*
 link("test1", new mailfile(fs, fs.genhand(), "Hello, world!\n"));
 link("test2", new mailfile(fs, fs.genhand(), "Wooba wooba...\n"));

 link("link1", new maillink(fs, fs.genhand(), "/usr/bin"));

 DirInode *d1 = new maildir(fs, fs.genhand(), this);
 DirInode *d2 = new maildir(fs, fs.genhand(), this);

 link("dir1", d1);
 link("dir2", d2);

 Inode *f1 = new mailfile(fs, fs.genhand(), "File with multiple names\n");
 d1->link("linked-file", f1);
 d2->link("another-link", f1);
 
 Inode *f2 = new mailfile(fs, fs.genhand(), "Piffle woodle.\n");
 d2->link("strange", f2);
*/
}

int
maildir::do_read(const up_preamble &pre, upp_repl &repl,
		  const upp_read_s &arg, upp_read_r &ret)
{
 int sz, off; // legth of returned bunch
 // Bunch is requested by kernel. Kernel asks for bunch of
 // arg.size bytes starting from arg.off
 
 if(!ifile)
  return EISDIR;

// ret.data.nelem = 0;
// return 0;

 // i = arg.file;
 off = arg.off;
 sz = arg.size;
 // l = arg.ctok;
 
 if(off >= length)
 {  
  ret.data.nelem = 0; // send EOF
 }
 else
 {  
  if(off + sz > length)
   sz = length - off;
  ret.data.alloc(ret.data.nelem = sz);
  ifile->seekg(start + off);
  ifile->read(ret.data.elems, sz);
 }
 return 0;
}

