/* Access ZIP archives.  */

#include "arcvfs.h"

#ifdef ARCFMT_ZIP

/* This is a very quick and dirty hack.  It works by simply snarfing the whole
   of a file into core and keeping it there until all FDs refering to it are
   closed.  This is fine for small archived files, tho.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static const char excmd[] = "unzip -p -qq %s %s";

ARC_DIRENT *
arc_read_zip (const char *zipfile)
{
  FILE *fp;
  char buf[4096];
  ARC_DIRENT *first = 0;
  char *name;
  long csize;

  csize = strlen (zipfile);
  if (csize < 4 || strcmp (zipfile + csize - 4, ".zip"))
    return 0;

  first = create_entry (zipfile, zipfile, 0);
  if (!first)
    return 0;
  first->pdir = first;
  first->size = -1;
  first->data.dir.first = 0;
  first->name = (char *) excmd;

  /* USIZE METHOD CSIZE CF% MM-DD-YY HH:MM CRC NAME  */
  sprintf (buf, "unzip -v -qq %s", zipfile);
  fp = popen (buf, "r");
  if (!fp)
    {
      perror (buf);
      return 0;
    }
  while (fgets (buf, sizeof (buf), fp))
    {
      long usize;
      ARC_DIRENT *ent;
      int dir_p;

      name = buf + strlen (buf);
      if (name > buf && name[-1] == '\n')
	*--name = '\0';
      if (name > buf && name[-1] == '/')
	{
	  *--name = '\0';
	  dir_p = 1;
	}
      else
	dir_p = 0;

      usize = strtol (buf, &name, 10);
      name = skip_field (name); /* METHOD */
      csize = strtol (name, &name, 10);
      name = skip_field (name); /* CF% */
      name = skip_field (name); /* DATE */
      name = skip_field (name); /* TIME */
      name = skip_field (name); /* CRC */
      while (*name == ' ')
	++name;

      ent = create_dirent (name, name, &first->data.dir.first, first);
      if (ent)
	{
	  if (dir_p)
	    {
	      ent->size = -1;
	      ent->data.dir.first = 0;
	    }
	  else
	    {
	      ent->size = usize;
	      ent->data.file.csize = csize;
	      ent->data.file.refc = 0;
	    }
	  ent->next = 0;
	}
    }
  fclose (fp);
  return first;
}

#endif
