// -*- C++ -*-

#ifndef _INTFSDIRINO_H_
#define _INTFSDIRINO_H_

#pragma interface

#include <DirInode.h>
#include <String.h>

class intfs;

class ifsDirIno: public DirInode
{
	const String name;
	ifsDirIno *dotdot;
	int fd;
	intfs &filesys;

	int open();
	void close();

	int updating;
	
protected:
	void update();
	int do_unlink(const up_preamble &, upp_repl &,
		      const upp_unlink_s &);
	int do_symlink(const up_preamble &, upp_repl &,
		       const upp_symlink_s &arg);
	int do_create(const up_preamble &, upp_repl &,
		      const upp_create_s &, upp_create_r &);
	int do_rename(const up_preamble &, upp_repl &,
		      const upp_rename_s &);
public:
	String path();
	String toppath();
	
	ifsDirIno(intfs &fs, Handle hand, ifsDirIno *parent,
		  String dirname);
	~ifsDirIno();

	int dupfd();
};

#endif /* _INTFSDIRINO_H_ */
