// -*- C++ -*-
// Passwords, specifically for ``homer''

#include "password.h"
#include <stdlib.h>
#include <string.h>

const pwent *
password::entry(int ino)
{
	pwent *pwe;

	for(pwe = pwlist; pwe != NULL; pwe = pwe->next)
		if (pwe->ino == ino)
			return pwe;
	return NULL;
}

const pwent *
password::entry(const char *name)
{
	pwent *pwe;

	for(pwe = pwlist; pwe != NULL; pwe = pwe->next)
		if (strcmp(name, pwe->name) == 0)
			return pwe;
	return NULL;
}

const pwent *
password::entry(const char *name, int len)
{
	pwent *pwe;

	for(pwe = pwlist; pwe != NULL; pwe = pwe->next)
		if (strncmp(name, pwe->name, len) == 0)
			return pwe;
	return NULL;
}

password::password()
{
	passwd *pw;
	pwent *pwe;

	update = time(0);
	pwlist = NULL;
	ino = 0;
	while(pw = getpwent())
	{
		pwe = new pwent;

		pwe->dir = strdup(pw->pw_dir);
		pwe->name = strdup(pw->pw_name);
		pwe->uid = pw->pw_uid;
		pwe->gid = pw->pw_gid;
		pwe->ino = ino++;
		pwe->next = pwlist;
		pwlist = pwe;
	}
	endpwent();
}

password::~password()
{
	pwent *next;

	for(; pwlist != NULL; pwlist = next)
	{
		next = pwlist->next;
		free(pwlist->dir);
		free(pwlist->name);
		delete pwlist;
	}
}

