/* -*- C -*- */

/*
 * Hooks to get in before the library functions
 */

/*
 * (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
 * This code is distributed under the terms of the
 * GNU General Public Licence.  See COPYING for more details.
 */

#include <syscall.h>
#include <sys/socket.h>
#include <sys/socketcall.h>

#include "netsys.h"

#ifndef __linux__
#error "This is Linux dependant"
#endif

static inline _syscall2(long, socketcall, int, call, unsigned long *, args);

/*
 * The C library doesn't allow us to intercept these, so
 * we have to do it manually
 */

int __recv(int fd, void *buf, int len, unsigned flags)
{
	unsigned long args[4];

	args[0] = fd;
	args[1] = (unsigned long)buf;
	args[2] = len;
	args[3] = flags;

	return socketcall(SYS_RECV, args);
}

int __recvfrom(int fd, void *buf, int len, unsigned flags,
	       struct sockaddr *from, int *fromlen)
{
	unsigned long args[6];

	args[0] = fd;
	args[1] = (unsigned long)buf;
	args[2] = len;
	args[3] = flags;
	args[4] = (unsigned long)from;
	args[5] = (unsigned long)fromlen;
	
	return socketcall(SYS_RECVFROM, args);
}
	
int __send(int fd, const void *buf, int len, unsigned flags)
{
	unsigned long args[4];
	
	args[0] = fd;
	args[1] = (unsigned long)buf;
	args[2] = len;
	args[3] = flags;

	return socketcall(SYS_SEND, args);
}

int __sendto(int sockfd, const void *buffer, int len, unsigned flags,
	     const struct sockaddr *to, int tolen)
{
	unsigned long args[6];

	args[0] = sockfd;
	args[1] = (unsigned long) buffer;
	args[2] = len;
	args[3] = flags;
	args[4] = (unsigned long) to;
	args[5] = tolen;

	return (socketcall (SYS_SENDTO, args));
}

int __connect(int sockfd, struct sockaddr *saddr, int addrlen)
{
        unsigned long args[3];

        args[0] = sockfd;
        args[1] = (unsigned long)saddr;
        args[2] = addrlen;
        return socketcall(SYS_CONNECT, args);
}

int __accept(int sockfd, struct sockaddr *peer, int *paddrlen)
{
        unsigned long args[3];

        args[0] = sockfd;
        args[1] = (unsigned long)peer;
        args[2] = (unsigned long)paddrlen;
        return socketcall(SYS_ACCEPT, args);
}
