// -*- C++ -*-

#ifndef _FTPFILE_H_
#define _FTPFILE_H_

#pragma interface

#include "ino.h"
#include <String.h>
#include <sys/types.h>
#include <time.h>

class ftpfile : public ino
{
	friend class docopy;
	
	class ftpdir *dir;
	class ftpconn *conn;
	String name;

	int do_read(const up_preamble &, upp_repl &,
		    const upp_read_s &, upp_read_r &);
	int do_iput(const up_preamble &, upp_repl &,
		    const upp_iput_s &);

	int updatefile();
	int updating;
	class LWP *upd_thread;
	
	struct waiting *wlist;
	struct waiting *addwlist(off_t off);
	void delwlist(struct waiting *);

	int open(int=0,int=0666);	// Open cache file
	void close();			// Close it
	int fd;				// fd of cache file

	void decref();
	
	int read(unsigned char *, size_t, off_t);
public:
	ftpfile(class ftpfs &, const String &name, class ftpdir *dir, class ftpconn *conn);
	~ftpfile();

	int is_uptodate() const;
	void setstats(size_t size, time_t time);
	void getstats(size_t &sz, time_t &time) const
	{
		sz = size;
		time = mtime;
	}
};
#endif /* _FTPFILE_H_ */
