/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* signal class interface definition                                      */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: signal.h,v 0.8 1995/05/01 22:04:55 drewvel Exp $             

#ifndef __SIGNALH_INC
#define __SIGNALH_INC

#include "configuration.h"
#include "parameters.h"
#include <unistd.h>

/*******************************************************************/

/*******************************************************************/
class Signal {
private:
  boolean sigOpen;
  Parms p;
  int sig;

  boolean DivDMABuffer(int num);
  boolean SetDSPValue(int cmd, char *name, int& parm, 
		      int comtype=1, int d=1);

  
public:
  Signal(char *fname, Parms& parms);
  ~Signal();
  
  boolean InitSignal(char *fname);
  void CloseSignal();
  
  int GetBufferSize() { return p.sampbufsize; }
  void SetBufferSize(int s) { p.sampbufsize=s; }
  
  boolean SignalOK() { return sigOpen; }

  void SetParms(Parms& parms);
  boolean UpdateParms(Parms& parms);
  Parms& GetParms();

  void Flush();
  
  inline void Receive8(sample8 array[])
    {
      read(sig, array, p.sampbufsize*sizeof(sample8));
    }

  inline void Receive16(sample16 array[])
    {
      read(sig, array, p.sampbufsize*sizeof(sample16));
    }  
  
  friend void ShowDSPSettings(Signal& s);
  friend class SpectrumAnalyzer;
  friend class Display;
  friend class SVGA_BAR_Display;
};

/*******************************************************************/
#endif __SIGNALH_INC
