/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* miscellaneous functions                                                */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: misc.h,v 0.8 1995/01/16 17:00:48 root Exp $             

#include <math.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>
#include "ftypes.h"
#include "configuration.h"

// needs external globalConfig declaration... 
// (this is used only as a header)

/* NOTE: think about more optimization for these routines */


/*******************************************************************/
inline void ConvertBuffer8SR(sample8 array[], real buf[], int N)
{
  register int i;

  if (gConfig.HWindow.val) 
    for (i=0; i<N; i++) {
      array[i]^=0x80;
      buf[i]=sin(PI * (real) i / (real) N) * 
	(real) (array[i]-gConfig.Offset8.val);
    }
  else
    for (i=0; i<N; i++) {
      array[i]^=0x80;
      buf[i]=(real) (array[i]-gConfig.Offset8.val);
    }
}

/*******************************************************************/
inline void ConvertBuffer16SR(sample16 array[], real buf[], int N)
{
  register int i;

  if (gConfig.HWindow.val) 
    for (i=0; i<N; i++) 
      buf[i]=sin(PI * (real) i / (real) N) * 
	(real) (array[i]-gConfig.Offset16.val);
  else
    for (i=0; i<N; i++) 
      buf[i]=(real) (array[i]-gConfig.Offset16.val);
}

/*******************************************************************/



// misc calibration functions
/*******************************************************************/
int Calibrate8(int a)
{
  const int size=CALSAMPSIZE;
  int offset=0;
  sample8 c=0, delta=0, old=0;

  ioctl(a, SOUND_PCM_SYNC, 0);

  for (int k=0; k<size; k++ ) {
    read(a, &c, 1);
    c^=0x80;
    delta=c-old;
    offset+=delta;
    old=c;
  }
  //offset/=size;

  return offset;
}

/*******************************************************************/
int Calibrate16(int a)
{
  const int size=CALSAMPSIZE;
  int offset=0;
  sample16 c=0, delta=0, old=0;

  ioctl(a, SOUND_PCM_SYNC, 0);

  for (int k=0; k<size; k++ ) {
    read(a, &c, 2);
    delta=c-old;
    offset+=delta;
    old=c;
  }

  return offset;
}
