/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* configuration structures                                               */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: gconfig.h,v 1.14 1995/04/15 19:40:29 drewvel Exp $             

#ifndef _GCONFIG_INCLUDED
#define _GCONFIG_INCLUDED

#include "configuration.h"

// these MUST be correct
#define NUMSTROPTIONS 1
#define NUMINTOPTIONS 41
#define NUMREALOPTIONS 7
#define NUMBOOLOPTIONS 8

struct StrOption {
  char val[32];
  char name[32];
};

struct IntOption {
  int val;
  char name[32];
};

struct RealOption {
  float val;
  char name[32];
};

struct BoolOption {
  boolean val;
  char name[32];
};


// string options first, then int options, then bool options
// make sure changes reflect in defaults.h
struct globalConfig {
  StrOption Device;
// 1 str option

  IntOption Screen;
  IntOption SizeScale;
  
  IntOption SampleRate;
  IntOption SampleSize;
  IntOption Attenuation;
  IntOption VPos;

  IntOption PlotType;
  IntOption LowFreq;
  IntOption HighFreq;
  IntOption RangeInc;

  IntOption NumBands;
  IntOption BarWidth;
  IntOption SegHeight;
  IntOption SegSpace;

  IntOption ForeGround;
  IntOption BackGround;
  IntOption GraphBG;
  IntOption LabelColor;
  IntOption AxesColor;

  IntOption LineColor;

  IntOption BarType;
  IntOption BarColor;
  IntOption MedBarVal;
  IntOption MedBarColor;
  IntOption HighBarVal;
  IntOption HighBarColor;

  IntOption BarClipColor;
  IntOption PeakColor;
  IntOption FadeSteps;

  IntOption PeakDisappearValue;
  IntOption BarClear;
  IntOption NumFreqLabels;
  IntOption FreqLabelOffset;
  
  IntOption x1;
  IntOption y1; 
  IntOption x2; 
  IntOption y2;

  IntOption Offset8;
  IntOption Offset16;

  // for 3D Wireframe
  IntOption XInterval;
  IntOption YInterval;

// 37 int options 

  RealOption Distance;
  RealOption RotX;
  RealOption RotY;
  RealOption RotZ;

  RealOption TransX;
  RealOption TransY;
  RealOption TransZ;

// 7 real options

  BoolOption Bits8;
  BoolOption LogScale;
  BoolOption LogFreqScale;
  BoolOption Continuous;
  BoolOption HWindow;
  BoolOption NoText;
  BoolOption FullScreen;
  BoolOption NoPerspective;
// 8 bool options
};

#endif _GCONFIG_INCLUDED
