
/** BENCHMARK CONFIGURATION ****/

/* Define this if you want to use one 4k buffer for all of the buffers
   in the buffer cache.  If you do not define this, you must have enough
   physical memory to allocate NR_PAGES pages of memory.  Note that with
   real buffers the performance seems to suffer somewhat - probably due
   to the motherboard cache not being able to satisfy the requests.  Also
   you have to "grow" the buffers as you would in real life.  Also see
   GROW_BUFFERS */

/* #define FAKE_BUFFERS */

/* Define this to the "memory" size of the machine that you are trying
   to simulate. 1024 == 4Mb. */

#define NR_PAGES 1024

/* Define one of these two.  The scsi option takes you all the way
   through the scsi code via scsi_debug, the HD_MAJOR option simply uses
   a fake disk function so that all requests complete immediately. */

#define MAJOR_NR SCSI_DISK_MAJOR
/* #define MAJOR_NR HD_MAJOR */

/* The number of shared pages of memory that cannot be reclaimed. */

#define NR_SHARED 0

/* Define this if you want to do both a read and a write (a la iozone).
   Without this, only a read is performed */

/* #define DO_WRITE */

/* Define this if you actually want to do the memcpy in block_read.c.
   This is a good part of the actual overhead in data transfers, and
   by removing this, you get a better sense of where the remaining
   overhead lies. */

#define DO_MEMCPY_FS

/* Define this if you want to grow the buffer cache to the full size
   of the defined memory (only when FAKE_BUFFERS is not defined) */

#define GROW_BUFFERS

/* These parameters simulate the actual latency in accessing a scsi disk.
   We assume a fixed time to send each command, and we assume  a certain
   datarate across the bus.  Note that the timer only has 10 ms granularity. */

/* The amount of time (in microseconds) to set up a scsi command */

#define SCSI_SETUP_LATENCY 20000

/* The simulated datarate.  Choose a number like what srawread reports
for large block sizes. */

#define SCSI_DATARATE 2200000
