/*\
|*| --------------------------------------------------------------------------
|*|     GGI device file definitions
|*| --------------------------------------------------------------------------
|*|
|*|	Copyright (C) 1995 by Andreas Beck, [becka@hp.rz.uni-duesseldorf.de]
|*|
|*|	This program is free software; you can redistribute it and/or modify
|*|	it under the terms of the GNU General Public License as published by
|*|	the Free Software Foundation; either version 2, or (at your option)
|*|	any later version.
|*|
|*|	This program is distributed in the hope that it will be useful,
|*|	but WITHOUT ANY WARRANTY; without even the implied warranty of
|*|	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*|	GNU General Public License for more details.
|*|
|*|	You should have received a copy of the GNU General Public License
|*|	along with this program; see the file COPYING.  If not, write to
|*|	the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
|*|
|*| ---------------------------------------------------------------------------
\*/



#include "scrdrv.h"

/* Some definitions for device-registration */

#define GRAPHICS_MAJOR 8
#define GRAPHICS_NAME  "graphics"

/* The ioctls : */

#define IOCTL_MAGIC_MASK	0xff000000
#define IOCTL_MAGIC		0xab000000

#define IOCTL_SUBSYSTEM_MASK	0x00ff0000		
#define SUBSYSTEM_CARD		0x00000000
#define SUBSYSTEM_MONITOR	0x00010000
#define SUBSYSTEM_CLOCK		0x00020000
#define SUBSYSTEM_RAMDAC	0x00030000

/* ioctls for the graphics device : */

#define GRAPH_SETMODE		0xab000001		/* Required */
#define GRAPH_GETMODE		0xab000002		/* Required */
#define GRAPH_GETSTATESIZE	0xab000003		/* Required */
#define GRAPH_SAVESTATE		0xab000004		/* Required */
#define GRAPH_RESTORESTATE	0xab000005		/* Required */
#define GRAPH_BGMODE		0xab000006		/* Required */
#define GRAPH_FGMODE		0xab000007		/* Required */
#define GRAPH_KEEPMODE		0xab000008		/* suser only */
#define GRAPH_SETDRAWINFO	0xab000009		/* Required must be executed before 
							   context-sensitive operations */
#define GRAPH_SETDEFFONT	0xab00000a		/* suser only */
#define GRAPH_GETDEFFONT	0xab00000b		/* Required   */

#define GRAPH_GETVT		0xab00000c		/* Required   */

#define GRAPH_SETVISWIN		0xab000011		/* Required */
#define GRAPH_GETVISWIN		0xab000012		/* Required */

#define GRAPH_TEST		0xab000040		/* This will only return 0 */

#define GRAPH_DRAWPIXEL		0xab000200		/* Required */
#define GRAPH_GETPIXEL		0xab000201		/* Required */
#define GRAPH_PUTPIXEL		0xab000202		/* Required */

							/* Optional from now on */
#define GRAPH_DRAWHLINE		0xab000208
#define GRAPH_GETHLINE		0xab000209
#define GRAPH_PUTHLINE		0xab00020a

#define GRAPH_DRAWBOX		0xab000210
#define GRAPH_GETBOX		0xab000211
#define GRAPH_PUTBOX		0xab000212		/* Display Sprite */

#define GRAPH_FILLSCREEN	0xab000220
#define GRAPH_DRAWCIRCLE	0xab000230

/* Ioctls for the ramdac */

#define RAMDAC_SETPAL		0xab030001		/* Required */
#define RAMDAC_GETPAL		0xab030002		/* Required */

/* Ioctls for the monitor */

#define	MONITOR_GETINFO		0xab010000
#define MONITOR_SETINFO		0xab010001		/* suser only */
#define MONITOR_SETPREFMODE	0xab010010		/* suser only */
#define MONITOR_GETPREFMODE	0xab010011
#define MONITOR_CLEARPREF	0xab010012		/* suser only */
#define MONITOR_POWERSAVE	0xab010020

/* mmap-constants for "offset" (which is unused) */

#define MMAP_LINEAR	0	/* Linear frame buffer */
#define MMAP_FRAME	1	/* banked frame buffer - optional ... for old apps */

/* ERROR CODES : */

#define ENODRVSUP		0x100	/* The Driver does not support the request */
#define ENODRVSUP_ALWAYS_MMAP	0x121	/* The Driver will never support this function, use mmap */
#define ENODRVSUP_ALWAYS_LOWER	0x122	/* The Driver will never support this function, use lower level funtions */
#define ENODRVSUP_ALWAYS_CANT	0x123	/* The Driver cannot support this function - similar to EBOGUS */
#define ENODRVSUP_MODE_MMAP	0x111	/* not in this mode ... */
#define ENODRVSUP_MODE_LOWER	0x112
#define ENODRVSUP_MODE_CANT	0x113
#define ENODRVSUP_NOW_MMAP	0x101	/* not now - retry ! */
#define ENODRVSUP_NOW_LOWER	0x102
#define ENODRVSUP_NOW_CANT	0x103

#define ENBOGUS			0x200	/* request makes no sense */
#define ENOMODESUP_CHIP		0x201	/* chipset does not support this mode */
#define ENOMODESUP_MON		0x202	/* monitor will not support the requested mode */
#define ENOMODESUP_LOOP		0x203	/* infinite recursion occurred */

/* MACROS : */

#define COPYPAR(size) \
	do{ int i; \
	    if ((i=verify_area(VERIFY_READ , (void *) arg, size))) return i; \
	    else memcpy_fromfs(parameters, (void *) arg, size); }while(0)

