/*
 * Monitor driver for SONY CPD-1730 (and other modern MultiSync's ???)
 *
 * NOTE   : THIS IS AN UNTESTED ALPHA VERSION
 * MEANING: USE AT YOUR OWN RISK, I AM NOT RESPONSIBLE FOR ANYTHING !!!!
 *
 * by Steffen Seeger [seeger@physik.tu-chemnitz.de]
 * for the scrdrv project by Andreas Beck
 */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/malloc.h>
#include <linux/fcntl.h>
#include <linux/vt.h>
#include <sys/ioctl.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include "graphdev.h"
#include "kgi-module.h"

static char *DISPTYPES[4]={ "B&W","EGA-8","EGA-16","VGA" };

static struct ggi_MonParams MonPar ={ {28000,58000},		/* hfreq range */
		 	   {     55,  110},	/* vfreq range */
			   1024,768,		/* display resolution */
			   382,242,		/* display size */
			   "SONY",		/* manufacturer */
			   "CPD-1730",		/* model */
			   VGA };		/* type (color) */
#define DEBUG(X) X

void ggi_GetMonitorParameters(struct ggi_MonParams * MP)
{ *MP=MonPar; }

int  ggi_CheckMonitorTiming  (struct ggi_Timing * MT, int olderr)
 { 
  int hfreq,vfreq;
  int width = MT->xwidth;

  if (MT->clock > 75000000)	/* limit for testing */
    MT->clock = 75000000;	/* this should be the bandwidth later */

  /* propose a timing for the given resolution */

  for(hfreq = MonPar.hfreq.max; hfreq > MonPar.hfreq.min; MT->clock -= 1000)
    /* Try from highest frequency down */
    {
       MT->xsyncstart = (width*(width     +41360)/40000) & 0xFFFFFFF8;
       MT->xsyncend   = (width*(width*7/10+ 8952)/ 8000) & 0xFFFFFFF8;
       MT->xend       = (width*(width     + 9360)/ 8000) & 0xFFFFFFF8;

       hfreq = MT->clock / MT->xend;
       if(MonPar.hfreq.max < hfreq)
         continue;

       MT->ysyncstart = MT->ywidth + 3;
       MT->ysyncend   = MT->ywidth + 9;
       MT->yend       = MT->ywidth + hfreq/1000 + 1; /* 1ms for flyback */

       MT->xsyncpol   = MT->ysyncpol	= 1; /* No matter for this monitor */

       vfreq = hfreq/MT->yend;
       if ((MonPar.vfreq.min <= vfreq) && (vfreq <= MonPar.vfreq.max))
         {
	     DEBUG(printk("accept %i Hz (%i kHz) refresh\n",vfreq,hfreq/1000));
	     return(TC_OK);
         };
    };
  return(-ENOMODESUP_MON);	/* invalid timing request */
 }

