/*
 * Generic Monitor driver for single frequency monitors (fixed H-freq, autosync on V)
 */
 
#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include "../include/scrdrv.h"
#include "monosync_config.h"

char kernel_version[]= UTS_RELEASE;

char *args=NULL;

static char *DISPTYPES[4]={ "B&W","EGA-8","EGA-16","VGA" };

void GGI_GetMonitorParameters(struct GGI_MonParams * MP)
{ *MP=MonPar; }

int  GGI_CheckMonitorTiming  (struct GGI_Timing * MT,int olderr)
{ double h,acfreq;
  int flg;

  /* Lower clock if out of bounds ... */
  for(flg=0;MT->clock>MT->xwidth*MonPar.hfreq.min;MT->clock-=1000,flg++)

  { h=MT->clock/1e9;			/* Pixels for 1 ns */

    MT->xend      =(MT->xwidth+
    		    (int)(h*MonTimeConst.xafter_ns)+
    		    MonTimeConst.xafter_pix)
    		   &0xfffffff8;

    acfreq=MT->clock/MT->xend;			/* Lines for 1 us */

    if (acfreq>MonPar.hfreq.max) continue;	/* Try lower clock */

    if (acfreq<MonPar.hfreq.min) 
      if (flg==0) return(TC_X_TOO_BIG);		/* Screen too wide even at highest clock */
      else        return(TC_Y_TOO_SMALL);	/* aspect ratio is bad ... */
      
    /* Here to increase performance - these do not matter for line frequency */
    MT->xsyncstart=(MT->xwidth+
    		    (int)(h*MonTimeConst.xbefore_ns)+
    		    MonTimeConst.xbefore_pix)
    		   &0xfffffff8;		/* must be a multiple of 8 */
    MT->xsyncend  =(MT->xwidth+
                    (int)(h*MonTimeConst.xlen_ns)+
                    MonTimeConst.xlen_pix)
                   &0xfffffff8;

    h=acfreq/1e6;				/* Lines for 1 us */
    
    MT->yend      =MT->ywidth+MonTimeConst.yafter_pix
    			     +MonTimeConst.yafter_us*h; /*flyback */

    acfreq/=MT->yend;

    if (acfreq>MonPar.vfreq.max) continue;	/* vertical too fast */

    if (acfreq<MonPar.vfreq.min) return(TC_Y_TOO_BIG);	/* Screen too tall */

    MT->xsyncpol  =MT->ysyncpol		= 1;	/* No matter for this monitor */

    MT->ysyncstart=MT->ywidth+MonTimeConst.ybefore_pix
    			     +MonTimeConst.ybefore_us*h;
    MT->ysyncend  =MT->ywidth+MonTimeConst.ylen_pix
    			     +MonTimeConst.ylen_us*h;
    return(TC_OK);
  }
  return(-ENOMODESUP_MON);
}

/* Argument parsing and initialization */

int init_module(void)
{ printk("Monitor driver V"VERSION" loading ...\n");
  printk("Manufacturer : %s\n",MonPar.manufact);
  printk("Model        : %s\n",MonPar.model);
  printk("Type         : %s - %s  [%dx%d]\n",
  	  DISPTYPES[MonPar.disptype/8],
  	  (MonPar.disptype&1) ? "Monochrome" : "Color",
  	  MonPar.xmaxdots,
  	  MonPar.ymaxdots);
  printk("Size         : %d mm x %d mm\n",
  	  MonPar.xsize,
  	  MonPar.ysize);
  printk("Frequencies  : %d-%d kHz , %d-%d Hz\n",
  	  MonPar.hfreq.min/1000 ,MonPar.hfreq.max/1000 ,
  	  MonPar.vfreq.min      ,MonPar.vfreq.max );
  return(0);
}  				  

void cleanup_module(void) {}
