/*\
|*| ---------------------------------------------------------------------------
|*|	VGA register definitions
|*| ---------------------------------------------------------------------------
|*|
|*|	Copyright (C) 1995 by Steffen Seeger, [seeger@physik.tu-chemnitz.de]
|*|
|*|	This program is free software; you can redistribute it and/or modify
|*|	it under the terms of the GNU General Public License as published by
|*|	the Free Software Foundation; either version 2, or (at your option)
|*|	any later version.
|*|
|*|	This program is distributed in the hope that it will be useful,
|*|	but WITHOUT ANY WARRANTY; without even the implied warranty of
|*|	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*|	GNU General Public License for more details.
|*|
|*|	You should have received a copy of the GNU General Public License
|*|	along with this program; see the file COPYING.  If not, write to
|*|	the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
|*|
|*| ---------------------------------------------------------------------------
\*/

#ifndef _vga_h
#define _vga_h

#define	MISCr	0x03CC
#define	MISCw	0x03C2
	#define	MISC_COLOR_IO	0x01
	#define MISC_ENB_RAM	0x02
	#define MISC_CLOCK_MASK	0x0C
	#define MISC_VIDEO_OFF	0x10
	#define MISC_PAGE_SEL	0x20
	#define	MISC_SYNC_MASK	0xC0

	#define MISC_NEG_HSYNC	0x40
	#define MISC_NEG_VSYNC	0x80
	#define	MISC_25MHZ_CLK	0x00
	#define	MISC_28MHZ_CLK	0x04
	#define MISC_350_LINES	MISC_NEG_HSYNC
	#define MISC_400_LINES	MISC_NEG_VSYNC
	#define	MISC_480_LINES	MISC_SYNC_MASK

#define	INS0r	0x03C2
	#define	INS0_VRETRACE	0x80

#define	INS1rm	0x03BA
#define INS1rc	0x03DA
	#define	INS1_DISP_OFF	0x01
	#define	INS1_LIGHTPEN_T	0x02
	#define	INS1_LIGHTPEN_S	0x04
	#define INS1_VRETRACE	0x08
	#define	INS1_DIAGNOSTIC	0x30

#define SEQI	0x03C4
#define	SEQD	0x03C5
	#define	SEQ_RESET	0x00
		#define	SR0_ASYNCRESET	0x01
		#define	SR0_SYNCRESET	0x02
		#define SR0_RESERVED	0xFC
	#define	SEQ_CLOCK	0x01
		#define	SR1_8DOTCLK	0x01
		#define	SR1_3CPUCYCLES	0x02
		#define	SR1_DISPLAY_OFF	0x20
	#define SEQ_WPLANE	0x02
		#define SR2_PLANE_MASK	0x0F
		#define SR2_PLANE0	0x01
		#define	SR2_PLANE1	0x02
		#define	SR2_PLANE2	0x04
		#define	SR2_PLANE3	0x08
	#define	SEQ_FONT	0x03
		#define	SR3_FONTA_MASK	0x2C
		#define	SR3_FONTB_MASK	0x13
	#define	SEQ_MEMMODE	0x04
		#define	SR4_256K_ACCESS	0x02
		#define	SR4_NO_ODD_EVEN	0x04
		#define	SR4_CHAINED	0x08

#define	CRTIm	0x03B4
#define CRTIc	0x03D4
#define CRTDm	0x03B5
#define	CRTDc	0x03D5
	#define	CRT_HTOTAL	0x00
	#define	CRT_HDISPLAYEND	0x01
	#define	CRT_HBLANKSTART	0x02
	#define	CRT_HBLANKEND	0x03
		#define	CR03_HBE_MASK	0x1F
		#define	CR03_DSKEW_MASK	0x60
	#define	CRT_HSYNCSTART	0x04
	#define	CRT_HSYNCEND	0x05
		#define	CR05_HSE_MASK	0x1F
		#define	CR05_HSKEW_MASK	0x60
	 	#define CR05_HBLANKEND_B5 0x80
	#define	CRT_VTOTAL	0x06
	#define	CRT_OVERFLOW	0x07
		#define	CR07_VTOTAL_B8		0x01
		#define	CR07_VDISPLAYEND_B8	0x02
		#define	CR07_VSYNCSTART_B8	0x04
		#define	CR07_VBLANKSTART_B8	0x08
		#define	CR07_LINECOMPARE_B8	0x10
		#define	CR07_VTOTAL_B9		0x20
		#define	CR07_VDISPLAYEND_B9	0x40
		#define	CR07_VSYNCSTART_B9	0x80
	#define	CRT_PRESETROW	0x08
		#define	CR08_ROWSCAN_MASK	0x1F
		#define	CR08_BYTEPAN_MASK	0x60
	#define	CRT_CHARHEIGHT	0x09
		#define	CR09_CHARHEIGHT_MASK	0x1F
		#define	CR09_VBLANKSTART_B9	0x20
		#define	CR09_LINECOMPARE_B9	0x40
		#define	CR09_DOUBLESCAN		0x80
	#define	CRT_CURSORSTART	0x0A
		#define	CR0A_CURSOR_START_MASK	0x1F
		#define	CR0A_CURSOR_OFF		0x20
	#define	CRT_STARTADDR_H	0x0C
	#define	CRT_STARTADDR_L	0x0D
	#define	CRT_CURSORADDR_H 0x0E
	#define	CRT_CURSORADDR_L 0x0F
	#define	CRT_VSYNCSTART	0x10
	#define	CRT_VSYNCEND	0x11
		#define	CR11_VSYNCEND_MASK	0x0F
		#define	CR11_CLEAR_VSYNC_IRQ	0x10
		#define	CR11_DISABLE_VSYNC_IRQ	0x20
		#define	CR11_5_DRAMCYCLES	0x40
		#define	CR11_LOCKTIMING		0x80
	#define	CRT_VDISPLAYEND	0x12
	#define	CRT_LOGICALWIDTH 0x13
	#define	CRT_UNDERLINE	0x14
		#define	CR14_UNDERLINE_MASK	0x1F
		#define	CR14_MEMCOUNT_BY_4	0x20
		#define	CR14_DOUBLEWORDMODE	0x40
	#define	CRT_VBLANKSTART	0x15
	#define	CRT_VBLANKEND	0x16
	#define	CRT_MODE	0x17
		#define	CR17_CGA_BANKING	0x01
		#define	CR17_HGA_BANKING	0x02
		#define	CR17_VDOUBLE_TIMING	0x04
		#define	CR17_WORDMODE		0x08
		#define	CR17_CGA_ADDR_WRAP	0x20
		#define	CR17_BYTE_MODE		0x40
		#define	CR17_ENABLE_SYNC	0x80
	#define	CRT_LINECOMPARE	0x18
	#define	CRT_CPULATCH	0x22
	#define	CRT_ATTRI	0x24

#define	GRCI	0x03CE
#define	GRCD	0x03CF
	#define	GRC_SET_RESET	0x00
		#define	GR0_DATA_MASK	0x0F
	#define	GRC_ENABLE	0x01
		#define	GR1_DATA_MASK	0x0F
	#define	GRC_COLOR_CMP	0x02
		#define	GR2_DATA_MASK	0x0F
	#define	GRC_OPERATION	0x03
		#define	GR3_ROTATE_MASK	0x07
		#define	GR3_NO_OP	0x00
		#define	GR3_AND_OP	0x08
		#define	GR3_OR_OP	0x10
		#define	GR3_XOR_OP	0x18
	#define	GRC_READPLANE	0x04
		#define	GR4_PLANEMASK	0x03
	#define	GRC_MODECONTROL	0x05
		#define	GR5_WRITEMODE0	0x00
		#define	GR5_WRITEMODE1	0x01
		#define	GR5_WRITEMODE2	0x02
		#define	GR5_WRITEMODE3	0x03
		#define	GR5_ENABLE_CMP	0x08
		#define	GR5_ODD_EVEN	0x10
		#define	GR5_ODD_EVEN_SHIFT 0x20
		#define	GR5_8BIT_COLOR	0x40
	#define	GRC_DONT_CARE	0x07
		#define	GR7_DATA_MASK	0x0F
	#define	GRC_BITMASK	0x08

#define	ATCRm	0x03BA
#define	ATCRc	0x03DA
#define	ATCI	0x03C0
	#define	ATCI_ENABLEDISPLAY	0x20
#define	ATCD	0x03C1
	#define	ATC_LAST_PALETTE 0x0F
	#define	ATC_MODECONTROL	0x10
		#define	AR10_GRAPHICS	0x01
		#define	AR10_MONOMODE	0x02
		#define	AR10_9DOT_CHARS	0x04
		#define	AR10_ENB_BLINK	0x08
		#define	AR10_TOP_PAN	0x20
		#define	AR10_8BIT_MODE	0x40
		#define	AR10_SELECT_B54	0x80
	#define	ATC_BORDER	0x11
	#define	ATC_PLANEENABLE	0x12
		#define	AR12_PLANEMASK	0x0F
		#define	AR12_VTESTMASK	0x30
	#define	ATC_HPAN	0x13
		#define	AR13_DATA_MASK	0x0F
	#define	ATC_PIXELPAD	0x14
		#define	AR14_DATA_MASK	0x0F

#if 0					/* These are in XFree regs3 already */
#define DAC_BASE	0x03C6
#define	DAC_MASK	0x03C6
#define	DAC_RD_ADDR	0x03C7		/* write only */
#define	DAC_STATUS	0x03C7		/* read only  */
#define	DAC_WR_ADDR	0x03C8
#define	DAC_DATA	0x03C9
#endif

#endif /* #ifdef _vga_h */
