/*\
|*| --------------------------------------------------------------------------
|*|     kernel module interface definitions
|*| --------------------------------------------------------------------------
|*|
|*|	Copyright (C) 1995 by Steffen Seeger, [seeger@physik.tu-chemnitz.de] 
|*|
|*|	This program is free software; you can redistribute it and/or modify
|*|	it under the terms of the GNU General Public License as published by
|*|	the Free Software Foundation; either version 2, or (at your option)
|*|	any later version.
|*|
|*|	This program is distributed in the hope that it will be useful,
|*|	but WITHOUT ANY WARRANTY; without even the implied warranty of
|*|	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*|	GNU General Public License for more details.
|*|
|*|	You should have received a copy of the GNU General Public License
|*|	along with this program; see the file COPYING.  If not, write to
|*|	the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
|*|
|*| ---------------------------------------------------------------------------
\*/


/*\
|*| The monitor driver should be kept as separate module, thus no init.
\*/

void	kgi_MonitorGetParameters (struct GGI_MonParams *params);
int	kgi_MonitorCheckTiming   (struct GGI_Timing *TM);
int	kgi_MonitorSetTiming     (struct GGI_Timing *TM);
int	kgi_MonitorIoctl (struct inode *inode, struct file *file, unsigned int cmd, unsigned long arg);


int	kgi_ClockInit (void);
void	kgi_ClockDone (void);
void	kgi_ClockGetParameters (struct GGI_Range *params);
int	kgi_ClockCheckTiming   (struct GGI_Timing *TM);
int	kgi_ClockSetTiming     (struct GGI_Timing *TM);
int	kgi_ClockIoctl (struct inode *inode, struct file *file, unsigned int cmd, unsigned long arg);


int	kgi_ChipsetInit (void);
void	kgi_ChipsetDone (void);
void	kgi_ChipsetGetParameters (struct GGI_ChipParams *params);
int	kgi_ChipsetCheckTiming   (struct GGI_Timing *TM);
int	kgi_ChipsetSetTiming     (struct GGI_Timing *TM);
int	kgi_ChipsetIoctl (struct inode *inode, struct file *file, unsigned int cmd, unsigned long arg);


int	kgi_RamdacInit (void);
void	kgi_RamdacDone (void);
void	kgi_RamdacGetParameters (struct GGI_DacParams *params);
int	kgi_RamdacCheckTiming   (struct GGI_Timing *TM);
int	kgi_RamdacSetTiming     (struct GGI_Timing *TM);
int	kgi_RamdacIoctl (struct inode *inode, struct file *file, unsigned int cmd, unsigned long arg);


int	kgi_Ioctl(struct inode *inode, struct file *file, unsigned int cmd, unsigned long arg);
int	kgi_Mmap(struct inode * inode, struct file * file, struct vm_area_struct * vma);

#define INTERNALERROR printk("GGI: %s: %i: internal error, please report.\n",\
			      __FILE__,__LINE__);

#ifdef __KERNEL__
 #ifdef DEBUG
  #define TRACE(X) X
 #else
  #define TRACE(X)
 #endif
#endif

