
#include <linux/fs.h>	/* Needed for some prototypes - so we include it */

/**
  *  Include file for General Graphics Interface
  **/

struct ggi_Range { int min,max; };
struct ggi_Ratio { int mul,div; };

enum ggi_Disptype {	BW    = 0,
			EGA_8 = 8,
			EGA_16=16,
			VGA   =24,
			T_MONO= 1 };
/* The MONO suffix means grayscale monitor - or (|) it to the rest ... */

struct ggi_MonParams {
	struct ggi_Range  pfreq;	/* Pixel Frequency (Bandwidth)*/
	struct ggi_Range  hfreq;	/* Horizontal Frequency range */
	struct ggi_Range  vfreq;	/* Vertical   Frequency range */
	int		  xmaxdots,
			  ymaxdots;	/* Maximum resolution (mask size) */
	int		  xsize,
			  ysize;	/* picture size in mm */
	char		  manufact[64],	/* manufacturer */
			  model[64];	/* model */
	enum ggi_Disptype disptype;	/* type of display */
	int		  VESA_pwr;	/* can do VESA power management */
	};

enum ggi_Graphtype { 	GT_TEXT		=  1,
		 	GT_1BIT		=  2,
		 	GT_4BIT_PLANES	=  4,
		 	GT_8BIT		=  8,
		 	GT_15BIT	= 16,
		 	GT_16BIT	= 32,
		 	GT_24BIT	= 64,
		 	GT_32BIT	=128	/* S3 RGB# format */ };

enum ggi_Flags {	FL_INTERLACE	=  1,
			FL_DOUBLESCAN	=  2 };	/* What more ? */

struct ggi_ChipParams {
	int			ramsize;	/* Installed (useable) RAM size */
	int			xmaxdots,	/* Maximum resolution */
				ymaxdots;	/* (register limits)  */
	char			manufact[64],	/* manufacturer */
				model[64];	/* model */
	enum ggi_Graphtype	graphtypes;	/* supported modes (ored together) */
	};

struct ggi_Timing_req {
	/* This is requested by the user and
	   changed as necessary by the driver */
	int	xvisible,		/* visible window size */
		yvisible;
	int	xvirtual,		/* virtual resolution,  */
		yvirtual;		/* i.e. scrolling range */
	enum	ggi_Graphtype 	graphtype;
	int	xtextgrid,
		ytextgrid;		/* font size for text mode */
};


struct ggi_Timing {
	struct ggi_Timing_req tr;

	/* These will be auto-calculated by the various drivers */
	int	clock;			/* in Hz */
	int	xwidth,
		xsyncstart,
		xsyncend,
		xend;			/* like in XFree */
	int	ywidth,
		ysyncstart,
		ysyncend,
		yend;			/* like in XFree */
	int	xsyncpol,		/* X sync polarity */
		ysyncpol;		/* Y  "      "     */
	int 	ymagnify;		/* CRTC-9 bits 0-4  (+1) */
	enum	ggi_Flags	flags;	/* special things like INTERLACE,DOUBLE_SCAN */

	/* New ideas not yet used */
	struct	ggi_Ratio	xpixel;	/* e.g. 9/8 for 9 bit textmode */
	struct	ggi_Ratio	ypixel; /* .5 for interlace, 2 for double Y */

	};

enum mr_rc {	MR_OK=0,
		MR_LOWER_CLOCK,
		MR_LOWEST_CLOCK,
		MR_HIGHER_CLOCK,
		MR_HIGHEST_CLOCK,
		MR_X_TOO_SMALL,
		MR_Y_TOO_SMALL,
		MR_X_TOO_BIG,
		MR_Y_TOO_BIG };
		
enum mr_cmd {	CMD_NONE=0,		/* Do what you like */
		CMD_MON_PERFECT,	/* get perfect timing */
		CMD_MON_SOME,		/* get any working timing */
		CMD_CLK_LOWER,		/* get lower clock */
		CMD_CLK_HIGHER		/* get higher clock */
		};

enum PowerSave  { PWR_ON=0,PWR_SUSPEND=1,PWR_OFF=2 };

struct ggi_Palentry {unsigned char r,g,b;};

struct ggi_Drawcontext { int fg_color;
			 int bg_color;
			 int drawmode; };
