/*\
|*| ----------------------------------------------------------------------------
|*|	S3 register definitions
|*| ----------------------------------------------------------------------------
|*| 
|*|	Copyright (C) 1995 by Steffen Seeger, [seeger@physik.tu-chemnitz.de]
|*|
|*|	This program is free software; you can redistribute it and/or modify
|*|	it under the terms of the GNU General Public License as published by
|*|	the Free Software Foundation; either version 2, or (at your option)
|*|	any later version.
|*|
|*|	This program is distributed in the hope that it will be useful,
|*|	but WITHOUT ANY WARRANTY; without even the implied warranty of
|*|	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*|	GNU General Public License for more details.
|*|
|*|	You should have received a copy of the GNU General Public License
|*|	along with this program; see the file COPYING.  If not, write to
|*|	the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
|*|
|*| ---------------------------------------------------------------------------
\*/

#ifndef _s3_h
#define _s3_h

#include "vga.h"


/* additional bits in MISC reg */
	#define MISC_EXT_CLK	0x0C

/* additional bits in InputStatus0 reg */
	#define INS0_MONITOR	0x10

/* Feature Control Register */
#define FCTRLr	0x03CA
#define FCTRLwm	0x03BA
#define FCTRLwc	0x03DA
	#define	FCTRL_OR_VSYNC	0x08

/* additional sequencer registers (SCLK ... serializer clock) */
	/* SEQ_CLOCK (SR0) */
		#define	SR0_SCLK2	0x04
		#define SR0_SCLK4	0x10
		#define SR0_DCLK2	0x08
	#define	SEQ_UNLOCK	0x08
		#define	SR8_MAGIC	0x06
	#define	SEQ_EXTENDED	0x0D
		#define	SRD_HSYNC_NORM	0x00
		#define SRD_HSYNC_OFF	0x10
		#define	SRD_HSYNC_ON	0x20
		#define	SRD_VSYNC_NORM	0x00
		#define	SRD_VSYNC_OFF	0x40
		#define SRD_VSYNC_ON	0x80

/* additional cathode ray tube controller registers */
	#define	CRT_HWC_FOREGROUND	0x0E
	#define	CRT_HWC_BACKGROUND	0x0F
	/* S3 VGA registers */
	#define	CRT_CHIPID	0x30
		#define	CR30_CHIPID	0xF0
		#define	CR30_REVISION	0x0F
	#define	CRT_MEMCONFIG0	0x31
		#define	CR31_ENBCPUBASE	0x01
		#define	CR31_2PAGE_SCRN	0x02
		#define	CR31_16BIT_BUS	0x04
		#define	CR31_ENHANCED	0x08
		#define	CR31_HISPEEDTXT	0x40
	#define	CRT_BACKCOMPAT1	0x32
		#define	CR32_7DOT_CHCLK	0x01
		#define	CR32_9DOT_CHCLK	0x02
		#define	CR32_FORCECHCLK	0x04
		#define	CR32_NON_VGA	0x08
		#define	CR32_ENB_VSYNC_IRQ 0x10
		#define	CR32_VGAMEMWRAP	0x40
	#define	CRT_BACKCOMPAT2	0x33
		#define	CR33_LOCK_VDE	0x02
		#define	CR33_VCLK_IS_DCLK 0x08
		#define	CR33_LOCK_DAC	0x10
		#define	CR33_NOBORDER	0x20
		#define	CR33_LOCK_PALETTE 0x40
		#define	CR33_NOFLICKER	0x80
	#define	CRT_BACKCOMPAT3	0x34
		#define	CR34_ENB_FIFO	0x10
		#define	CR34_LOCK_SR1	0x20
		#define	CR34_LOCK_CLKSEL 0x80
	#define	CRT_LOCK	0x35
		#define	CR35_CPUBASE_MASK 0x0F
		#define	CR35_LOCK_VTIMING 0x10
		#define	CR35_LOCK_HTIMING 0x20
		#define	CR35_LOCK_TIMING  0x30
	#define	CRT_CONFIG1	0x36
		#define	CR36_VESALOCAL	0x01
		#define	CR36_PCI	0x02
		#define	CR36_BUSMASK	0x03
		#define	CR36_FASTPAGERAM 0x0C
		#define	CR36_EDO_RAM	0x08
		#define	CR36_RAMMASK	0x0C
		#define	CR36_ENB_BIOS	0x10
		#define	CR36_MEMSIZE_MASK 0xE0
		#define	CR36_8MB	0x60
		#define	CR36_6MB	0xA0
		#define	CR36_4MB	0x00
		#define	CR36_3MB	0x40
		#define	CR36_2MB	0x80
		#define	CR36_1MB	0xC0
	#define	CRT_CONFIG2	0x37
		#define	CR37_S3_ENABLE	0x01
		#define	CR37_TESTMODE	0x02
		#define	CR37_32K_BIOS	0x04
		#define	CR37_DUAL_CAS	0x08
		#define	CR37_VL_SNOOP	0x10
		#define	CR37_MONITORID	0xE0
	#define	CRT_LOCK1	0x38
		#define	CR38_MAGIC	0x48
	#define	CRT_LOCK2	0x39
		#define	CR39_MAGIC	0xA0
		#define	CR39_CR36MAGIC	0xA5
	#define	CRT_MISC1	0x3A
		#define	CR3A_REFRESH0	0x00
		#define	CR3A_REFRESH1	0x01
		#define	CR3A_REFRESH2	0x02
		#define	CR3A_REFRESH3	0x03
		#define	CR3A_ALT_REFRESH 0x04
		#define	CR3A_REFRESHMASK 0x04
		#define	CR3A_TOP_MEM	0x08
		#define	CR3A_NO4BPPMODE	0x10
		#define	CR3A_HISPEEDTXT	0x20
		#define	CR3A_NOPCIBURST	0x80
		#define	CR3A_PCIMASK	0x80
	#define	CRT_FIFOSTART	0x3B
	#define	CRT_INTERLACESTART 0x3C
	/* system configuration resgisters */
	#define	CRT_SYSCONFIG	0x40
		#define	CR40_UNLOCK_ENH	0x01
		#define	CR40_1WAITSTATE	0x10
		#define	CR40_LATCHDELAY	0x20
		#define	CR40_OVERLAP_0	0x00
		#define	CR40_OVERLAP_1	0x40
		#define	CR40_OVERLAP_2	0x80
		#define	CR40_OVERLAP_3	0xC0
		#define CR40_BUSMASK	0xF0
	#define	CRT_BIOSFLAG	0x41
	#define	CRT_EXTMODE1	0x42
		#define	CR42_DCLK_MASK	0x0F
		#define	CR42_INTERLACED	0x20
	#define	CRT_EXTMODE2	0x43
		#define	CR43_VCLKDOUBLE	0x01
		#define	CR43_DOUBLE_HTIMING 0x80
	/* hardware cursor registers */
	#define	CRT_HWC_MODE	0x45
		#define	CR45_HWC_ENABLE	0x01
		#define	CR45_HWC_BITS	0x0C
		#define	CR45_HWC_1280	0x10
		/* there are more to follow, but not needed now. */
	/* system extension registers */
	#define	CRT_SYSCONTROL1	0x50
		#define	CR50_WIDTHMASK	0xC1
		#define	CR50_1024	0x00
		#define	CR50_2048	0x00
		#define CR50_640	0x40
		#define	CR50_800	0x80
		#define	CR50_1280	0xC0
		#define	CR50_1152	0x01
		#define	CR50_1600	0x81
		#define	CR50_4BPP	0x00
		#define	CR50_8BPP	0x00
		#define	CR50_16BPP	0x10
		#define	CR50_32BPP	0x30
		#define	CR50_BREQ_ENB	0x04
	#define	CRT_SYSCONTROL2	0x51
		#define	CR51_LOGICALWIDTH_B8	0x10
		#define	CR51_LOGICALWIDTH_B9	0x20
	#define	CRT_BIOSFLAG1	0x52
	#define	CRT_MEMCONTROL1	0x53
		#define	CR53_ENB_WRITEPERBIT 0x01
		#define	CR53_ENB_MMIO	     0x10
		#define	CR53_64BIT_VRAM	     0x20
		#define	CR53_SWAPNIBBLES     0x40
	#define	CRT_MEMCONTROL2	0x54
		#define	CR54_M_MASK	0xF8
	#define	CRT_DACCONTROL	0x55
		#define	CR55_DAC_MASK	0x03
		#define	CR55_INPORT_ENB	0x04
		#define	CR55_HWC_X11	0x10
		#define	CR55_VCLK_OFF	0x80
	#define	CRT_EXTSYNC1	0x56
		#define	CR56_REMOTE	0x01
		#define	CR56_NOHSYNCCLR	0x08
		#define	CR56_START_ODD	0x10
		#define	CR56_SYNC_OFF	0x20
	#define	CRT_EXTSYNC2	0x57
	#define	CRT_LAWCONTROL	0x58
		#define	CR58_LAW_64K	0x00
		#define	CR58_LAW_1MB	0x01
		#define	CR58_LAW_2MB	0x02
		#define	CR58_LAW_8MB	0x03
		#define	CR58_VL_T1_LATCH 0x08
		#define	CR58_LAW_ENABLE	0x10
		#define	CR58_SAM_256	0x40
	#define	CRT_LAW_POS_H	0x59
	#define	CRT_LAW_POS_L	0x5A
	#define	CRT_BIOSFLAG2	0x5B
	#define	CRT_GOUT_PORT	0x5C
		#define	CR5C_CLOCK_MASK	0x0F
		#define	CR5C_GOUT_MASK	0xF0
	#define	CRT_EH_OVERFLOW	0x5D
		#define	CR5D_HTOTAL_B8	    0x01
		#define	CR5D_HDISPLAYEND_B8 0x02
		#define	CR5D_HBLANKSTART_B8 0x04
		#define	CR5D_HBLANKEND_B6   0x08
		#define	CR5D_HSYNCSTART_B8  0x10
		#define	CR5D_HSYNCEND_B5    0x20
		#define	CR5D_FIFOSTART_B8   0x40
		#define	CR5D_BGT_B8         0x08
	#define	CRT_EV_OVERFLOW	0x5E
		#define	CR5E_VTOTAL_B10	     0x01
		#define	CR5E_VDISPLAYEND_B10 0x02
		#define	CR5E_VBLANKSTART_B10 0x04
		#define	CR5E_VSYNCSTART_B10  0x10
		#define	CR5E_LINECOMPARE_B10 0x40
	#define	CRT_BGRANTTERM	0x5F
	#define	CRT_MEMCONTROL3	0x60
	#define	CRT_MEMCONTROL4	0x61
		#define	CR61_L_DATAMASK	0x07
		#define	CR61_L_ENABLE	0x80
	#define	CRT_MEMCONTROL5	0x62
	#define	CRT_EXTSYNCADJ	0x63
	#define	CRT_GENLOCKADJ	0x64
		/* may be we need this reg sometimes */
	#define	CRT_EXTMISC0	0x65
		#define	CR65_SE_DELAY	0x01
		#define	CR65_DISABLE_SC	0x02
		#define	CR65_0x3C3	0x04
		#define	CR65_SAM_MASK	0xC3
	#define	CRT_EXTMISC1	0x66
		#define	CR66_VCLK_DIV_MASK   0x07
		#define	CR66_VCLK_DCLK	     0x00
		#define	CR66_VCLK_DCLK2	     0x01
		#define	CR66_VCLK_DCLK4	     0x02
		#define	CR66_VCLK_DCLK8	     0x03
		#define	CR66_VCLK_DCLK16     0x04
		#define	CR66_VCLK_DCLK32     0x05
		#define	CR66_SCLK_IS_VCLK    0x08
		#define	CR66_32P_SID	     0x10
		#define	CR66_32S_SID	     0x30
		#define	CR66_64S_SID	     0x00
		#define	CR66_SID_MASK	     0x30
		#define	CR66_128S_SID        0x20
		#define	CR66_PIXELBUS_OFF    0x40
		#define	CR66_PCI_DISCONNECT  0x80
	#define	CRT_EXTMISC2	0x67
		#define	CR67_NO_INVERT_VCLK  0x01
		#define	CR67_DAC_MASK	0xF0
		#define	CR67_DAC_MODE0	0x00
		#define	CR67_DAC_MODE1	0x20
		#define	CR67_DAC_MODE2	0x40
		#define	CR67_DAC_MODE3	0x60
		#define	CR67_DAC_MODE8	0x10
		#define	CR67_DAC_MODE9	0x30
		#define	CR67_DAC_MODEA	0x50
		#define	CR67_DAC_MODEB	0x70
	#define	CRT_CONFIG3	0x68
		#define	CR68_CAS_MASK	0x03
		#define	CR68_MAD_MASK	0x0C
		#define	CR68_RASLOW_MASK 0x30
		#define	CR68_RASPCG_MASK 0xC0
	#define	CRT_EXTCONTROL3	0x69
		#define	CR69_STARTADDR_MASK 0x0F
	#define	CRT_EXTCONTROL4	0x6A
		#define	CR69_CPUBASE_MASK   0x3F
	#define	CRT_BIOS3	0x6B
	#define	CRT_BIOS4	0x6C
	#define	CRT_MISC3	0x6D
		#define	CR6D_BLANK_DELAY_MASK	0x07

		
		

/* setup registers */
#define	S3_SETUP	0x0102
	#define	S3_WAKEUP	0x01
#define	S3_SUBSYSTEM	0x46E8
	#define	S3_ENABLE	0x08
	#define	S3_DISABLE	0x10


#endif /* _s3_h  */ 
