/*\
|*| --------------------------------------------------------------------------
|*|	ATT20c505 RAMDAC register definitions 
|*| --------------------------------------------------------------------------
|*|
|*|	Copyright (C) 1995 Steffen Seeger [seeger@physik.tu-chemnitz.de]
|*|
|*|	This program is free software; you can redistribute it and/or modify
|*|	it under the terms of the GNU General Public License as published by
|*|	the Free Software Foundation; either version 2, or (at your option)
|*|	any later version.
|*|
|*|	This program is distributed in the hope that it will be useful,
|*|	but WITHOUT ANY WARRANTY; without even the implied warranty of
|*|	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*|	GNU General Public License for more details.
|*|
|*|	You should have received a copy of the GNU General Public License
|*|	along with this program; see the file COPYING.  If not, write to
|*|	the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
|*|
|*| ---------------------------------------------------------------------------
\*/

#ifndef _20c505_h
#define _20c505_h

/*\
|*| NOTE:	The register numbers are rearranged to allow for simple 
|*|		arithmetics to select the I/O ports to access. (On a 964 -
|*|		is this type of RAMDAC used somewhere else ???)
|*|
|*|     Translation scheme: (RS[0:3] (bin), new register number (hex))
|*|
|*|		(0010,0), (0011,1), (0000,2), (0001,3),
|*|		(0110.4), (0111,5), (0100,6), (0101,7),
|*|		(1010,8), (1011,9), (1000,A), (1001,B),
|*|		(1110,C), (1111;D), (1100,E), (1101;F)
\*/

#define	DAC_PIXEL_MASK	0x0	/* pixel read mask register     */
#define	DAC_PR_INDEX	0x1	/* palette read index register  */
#define	DAC_PW_INDEX	0x2	/* palette write index register */
	#define	DAC_PW_CR3_INDEX	0x01	/* CONTROL3 register index    */

#define	DAC_P_DATA	0x3	/* palette data (r/w) register  */

#define	DAC_CONTROL0	0x4	/* DAC configuration register 0 */
	#define	DAC_C0_SLEEP_MODE	0x01	/* (CLK < 50MHz for wakeup!)  */
	#define	DAC_C0_8BIT		0x02	/* DAC's are 8 bits wide      */
	#define	DAC_C0_SYNC_ON_RED	0x04	/* composite sync on red      */
	#define DAC_C0_SYNC_ON_GREEN	0x08	/* composite sync on green    */
	#define	DAC_C0_SYNC_ON_BLUE	0x10	/* composite sync on blue     */
	#define	DAC_C0_BLANK_LEVEL	0x20	/* (only composite sync)      */
	#define	DAC_C0_NO_SLEEPSCLK	0x40	/* disable SCLK during sleep  */
	#define	DAC_C0_EXT_UNLOCK	0x80	/* unlock extended regs       */

#define	DAC_CR_INDEX	0x5	/* color read index register	*/
#define DAC_CW_INDEX	0x6	/* color write index register   */
#define	DAC_C_DATA	0x7	/* color data (r/w) register	*/

#define	DAC_STATUSREG	0x8	/* status register, read only   */
	#define	DAC_ST_MOD3_COUNTER	0x03	/* modulo 3 counter mask      */
	#define	DAC_ST_MPU_READ_CYCLE	0x04	/* last was read cycle        */
	#define DAC_ST_SENSE		0x08	/* sense state	              */
	#define	DAC_ST_ID_MASK		0x70	/* device type ID mask 	      */
		#define	DAC_ATT20C504	0x40
		#define	DAC_ATT20C505	0x50
		#define	DAC_ATT20C506	0x60
	#define	DAC_ST_ATT_DEVICE	0x80	/* device is ATT device	      */

#define	DAC_CURSOR	0x9	/* cursor pattern register	*/

#define	DAC_CONTROL1	0xA	/* DAC configuration register 1 */
	#define	DAC_C1_HIGH_MUX		0x01	/* use high word (1?bit modes)*/
	#define	DAC_C1_SRC_CTRL		0x02	/* select pixel switch source */
	#define	DAC_C1_2_1_MUX		0x04	/* mux mode for 1?bit modes   */
	#define	DAC_C1_CLUT_BYPASS	0x10	/* bypass CLUT in 8 bit modes */
	#define DAC_C1_MODE_MASK	0xE8	/* these bits define the mode */

	#define	DAC_C1_24BPP		0x00	/* 24 bpp (888 weight) 	      */
	#define	DAC_C1_16BPP		0x28	/* 16 bpp (565 weight)	      */
	#define	DAC_C1_15BPP		0x20	/* 15 bpp (555 weight)        */
	#define	DAC_C1_8BPP		0x40	/*  8 bpp (indexed)	      */
	#define	DAC_C1_4BPP		0x60	/*  4 bpp (indexed)	      */
	#define	DAC_C1_1BPP		0x80	/*  1 bpp (indexed)           */

#define DAC_CONTROL2	0xB	/* DAC configuration register 2 */
	#define	DAC_C2_OFF_CURSOR	0x00	/* no hardware cursor	      */
	#define	DAC_C2_WIN_CURSOR	0x01	/* 3 color WIN type cursor    */
	#define	DAC_C2_REV_CURSOR	0x02	/* 2 color with reverse video */
	#define	DAC_C2_X11_CURSOR	0x03	/* 2 color X11 type cursor    */
	#define	DAC_C2_PACKED_CLUT	0x04	/* packed or spaced CLUT      */
	#define	DAC_C2_INTERLACED	0x08	/* interlaced mode 	      */
        #define DAC_C2_PCLK0            0x00    /* select PCLK0               */
	#define	DAC_C2_PCLK1            0x10	/* select PCLK1               */
	#define	DAC_C2_ENHANCED_MODE	0x20	/* normal is VGA mode 	      */
	#define	DAC_C2_DAC_TEST		0x40	/* select test path	      */
	#define	DAC_C2_SCLK_DISABLE	0x80	/* disable SCLK output	      */


#define	DAC_CURSOR_X	0xC	/* cursor location, 16 bit I/O  */
#define DAC_CURSOR_Y	0xE	/* cursor location, 16 bit I/O  */


/* CONTROL3 is an internal register and addressed indirectly. */
	#define	DAC_CR3_ADDR_B8		0x01	/* ADDR bit 8		      */
	#define	DAC_CR3_ADDR_B9		0x02	/* ADDR bit 9		      */
	#define	DAC_CR3_LARGE_CURSOR	0x04	/* 64x64 instead of 32x32     */
	#define	DAC_CR3_DOUBLE_CLK	0x08	/* double clock (505 only!)   */
	#define	DAC_CR3_SWAP_NIBBLES	0x10	/* swap nibbles in 4bpp modes */


#endif /* _20c505_h */
