/* 
   VGA generic clock (2 Clocks) driver.
   
   Copyright (C) 1995 Andreas Beck - becka@sunserver1.rz.uni-duesseldorf.de

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/malloc.h>
#include <linux/fcntl.h>
#include <linux/vt.h>
#include <sys/ioctl.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include "../include/graphdev.h"
#include "../include/kgi-module.h"
#include "../include/vga_prg.h"

#define SET_CLOCKBITS_0_1(no)   ( outb(( inb(VGA_MISC_R) & 0xf3) | (((no) << 2) & 0x0C) , VGA_MISC_W) ) /* bits 0 and 1 of clock no */

struct ggi_Range ClockPar[]= {
   { 25175000, 25175000},
   { 28322000, 28322000},
   {0,0} };

int clock_order[]=	{ 0,	/* 25.175*/
			  1,	/* 28.322*/
			};


struct ggi_Range *kgi_GetClockParameters(void)
{ return ClockPar; }

static int clock_ok(int old,int new)
{ old/=new/100; return(old>=99&&old<=101); }

/* This routine is generic for all fixed clock generators */

int kgi_CheckClockTiming(struct ggi_Timing *TM,int cmd)
{ int index;

  if (cmd==CMD_CLK_LOWER)
  { if (ClockPar[0].min > TM->clock)
    { TM->clock=ClockPar[0].min;return MR_LOWEST_CLOCK; }
            
    index = 0;
    while (ClockPar[index].max != 0)     /* if max = 0, then {min,max} will be {0,0} ==> end */
    { if (clock_ok(ClockPar[index].min,TM->clock)) 
      { TM->clock=ClockPar[index].min;return MR_OK;}
      if (ClockPar[index].min >  TM->clock) break;
      index++;    
    }
  TM->clock=ClockPar[index-1].min;return(MR_LOWER_CLOCK);
  }
  else if (cmd==CMD_CLK_HIGHER)
  { index = 0;
    while (ClockPar[index].max != 0)     /* if max = 0, then {min,max} will be {0,0} ==> end */
    { if (clock_ok(ClockPar[index].min,TM->clock)) 
      { TM->clock=ClockPar[index].min;return MR_OK;}
      if (ClockPar[index].min >  TM->clock) break;
      index++;    
    }
    if (ClockPar[index].max == 0)
    { TM->clock=ClockPar[index-1].min;return MR_HIGHEST_CLOCK; }
    TM->clock=ClockPar[index-1].min;return(MR_HIGHER_CLOCK);
  }
  else
  { printk("Whee - going mad !\n");
    return(-ENOMODESUP_CHIP); }
}  

int kgi_SetClockTiming(struct ggi_Timing *TM)
{   
    /* standard VGA clocks */
    if (TM->clock==0UL||TM->clock==25175000)
      { SET_CLOCKBITS_0_1(0);return(0);}
    if (TM->clock==28322000)
      { SET_CLOCKBITS_0_1(1);return(0);}
    return(-1);
}

int kgi_ClockIoctl(struct inode *inode, struct file *file, \
        unsigned int cmd, unsigned long arg)
{ switch(cmd)
  { default : return -ENODRVSUP_ALWAYS_CANT; }
}        

int kgi_ClockInit(void)
{ printk("VGA Generic Clock driver V"VERSION" loading ...\n");
  return(0); }

void kgi_ClockCleanup(void) {}
