/*\
|*| ---------------------------------------------------------------------------
|*|	pseudo code monitor driver
|*| ---------------------------------------------------------------------------
|*|
|*|	Copyright (C) 1995, The SCRDRV Project
|*|
|*|	This program is free software; you can redistribute it and/or modify
|*|	it under the terms of the GNU General Public License as published by
|*|	the Free Software Foundation; either version 2, or (at your option)
|*|	any later version.
|*|
|*|	This program is distributed in the hope that it will be useful,
|*|	but WITHOUT ANY WARRANTY; without even the implied warranty of
|*|	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*|	GNU General Public License for more details.
|*|
|*|	You should have received a copy of the GNU General Public License
|*|	along with this program; see the file COPYING.  If not, write to
|*|	the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
|*|
|*| ---------------------------------------------------------------------------
\*/

/*\
|*|	system includes
\*/

#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>

/*\
|*|	GGI includes
\*/

#include "graphdev.h"
#include "kgi-module.h"

/*\
|*|	driver specific #define's should go here  
\*/

#define MON_VERSION "0.00 ALHPA"

char kernel_version[]= UTS_RELEASE;

static struct GGI_MonParams
params = {
		{      0,   0},	/* pixel clock range */
		{      0,   0},		/* hfreq range */
		{      0,   0},		/* vfreq range */
		       0,   0,		/* display resolution */
		       0,   0,		/* display size */
		  "Someone's",		/* manufacturer */
		"unknown monitor",	/* model */
		VGA,			/* display type (color) */
		SYNC_NORMAL		/* sync type */
	   };

/*\
|*|	GGI interface
\*/

void
kgi_MonitorGetParameters(struct GGI_MonParams * MP)
{
  /*\
  |*|	return monitor parameters if requested.
  \*/
  *MP=MonPar;
}

int
kgi_MonitorCheckTiming  (struct GGI_Timing *TM)
{
  /*\
  |*|	This function is responsible for calculating proper timings to do
  |*|	a desired mode. The fields initialised are TM->tr, TM->xwidth,
  |*|	TM->ywidth. It gets called twice, once to propse a timing and a
  |*|	second time to check this (possibly modified) timing.
  |*|
  |*|	return values:	TRUE	The requested timing can be done. TM->clock
  |*|				and the timing fields may be modified if
  |*|				out of limits.
  |*|			FALSE	There is no way to do this mode.
  |*|
  |*|	NOTE:	DO NOT MODIFY *TM IF NOT RETURNING TRUE and if not
  |*|		NECCESSARY  !
  \*/
}

int
kgi_MonitorSetTiming(struct GGI_Timing *TM)
{
  /*\
  |*|	Setup monitor for the desired (checked) timing. This is usually
  |*|	impossible for current CRT monitors but may be required by future
  |*|	displays, such as TFT/LCD displays (???). You don't need to check
  |*|	the timing again, it is guaranteed to be valid (according to
  |*|	kgi_MonitorCheckTiming()).
  |*|
  |*|	return values:	TRUE	The hardware has been setup.
  |*|			FALSE	Hardware setup failed.
  \*/
}

int
kgi_MonitorIoctl (struct inode *inode, struct file *file, unsigned int cmd,
		  unsigned long arg)
{
  /*\
  |*|	Not used yet, but chipselection for generic drivers, parameter setup
  |*|	or chip specific functions may go here (one day ;-).
  |*|
  |*|	return values:	according to usual ioctl() functions.
  \*/
}


/*\
|*|	module initialisation stuff
\*/

int
init_module(void)
{
  /*\
  |*|	Module initialisation goes here. Do hardware detecition (if possible)
  |*|	and initialisation (if necessary).
  |*|	return values:	as usual for modules
  \*/
}

void
cleanup_module(void)
{
  /*\
  |*|	Shutdown module. Thus do any restauration work if necessary.
  \*/
}

