/*\
|*| ---------------------------------------------------------------------------
|*|	pseudo code ramdac driver
|*| ---------------------------------------------------------------------------
|*|
|*|	Copyright (C) 1995, The SCRDRV Project
|*|
|*|	This program is free software; you can redistribute it and/or modify
|*|	it under the terms of the GNU General Public License as published by
|*|	the Free Software Foundation; either version 2, or (at your option)
|*|	any later version.
|*|
|*|	This program is distributed in the hope that it will be useful,
|*|	but WITHOUT ANY WARRANTY; without even the implied warranty of
|*|	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*|	GNU General Public License for more details.
|*|
|*|	You should have received a copy of the GNU General Public License
|*|	along with this program; see the file COPYING.  If not, write to
|*|	the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
|*|
|*| ---------------------------------------------------------------------------
\*/

/*\
|*|	system includes
\*/

#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <asm/io.h>


/*\
|*|	GGI includes
\*/

#include "scrdrv.h"
#include "graphdev.h"
#include "kgi-module.h"


/*\
|*|	driver specific #define's
\*/

#define DAC_VERSION "0.00 ALPHA"

static struct GGI_DacParams dac_params = {...};


/*\
|*|	GGI interface
\*/

int
kgi_RamdacInit(void)
{
  /*\
  |*|	Do hardware detection (if possible) and initialisation (if neccessary)
  |*|	here. This function is called once during initialisation thus copyright
  |*|	messages shall go here.
  |*|
  |*|	return values:	TRUE	Initialisation/detection successful.
  |*|			FALSE	Initialisation/detection failed.
  \*/
}

void
kgi_RamdacDone(void)
{
  /*\
  |*|	Do deinitialisation here.
  \*/
}

void
kgi_RamdacGetParameters(struct GGI_DacParams *params)
{
  /*\
  |*|	return DAC parameters on request.
  \*/
}

int
kgi_RamdacCheckTiming(struct GGI_Timing *TM)
{
  /*\
  |*|	Check if the requested mode can be done (considering DCLK rate and
  |*|	color depth. Enter necessary multiplex mode and DCLK rate (if out of
  |*|	limits). This function gets called twice, once to propose a multiplex
  |*|	mode and check the timing and once to check this (possibly modified)
  |*|	timing.
  |*|
  |*|	return values:	TRUE	mode can by done.
  |*|			FALSE	mode not supported
  |*|
  |*|	NOTE: DO NOT MODIFY *TM IF NOT RETURNING TRUE OR IF NOT NECCESSARY !
  \*/
}

int
kgi_RamdacSetTiming(struct GGI_Timing *TM)
{
  /*\
  |*|	Setup Timing. You don't need to check the timing again. It is
  |*|	guaranteed to be valid (according to kgi_RamdacCheckTiming()).
  |*|
  |*|	return values:	TRUE	hardware setup successful.
  |*|			FALSE	hardware setup failed. (PRESERVE STATE!)
  |*|	side effects:	hardware setup.
  \*/
}

int
kgi_RamdacIoctl (struct inode *inode, struct file *file, unsigned int cmd,
		 unsigned long arg)
{
  /*\
  |*|	Not used yet, but chipselection for generic drivers, parameter setup
  |*|	or chip specific functions may go here (one day ;-).
  |*|
  |*|	return values:	according to usual ioctl() functions.
  \*/
}
