/*
 * This file is part of fb, the frame buffer device, a grafics card driver for
 *                                linux.
 *
 *      Copyright (C) 1995 Michael Weller (eowmob@exp-math.uni-essen.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Michael Weller (eowmob@exp-math.uni-essen.de or
 * mat42b@aixrs1.hrz.uni-essen.de) Heiderhoefen 116b,
 * D 46049 Oberhausen, Germany.
 */

#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/kd.h>


#define SYS_ERROR(str) { perror(str); exit(2); }

char *myname;
int tty_fd;

int main(int argc, char *argv[]) {
	myname = strrchr(argv[0], '/');
	if (myname)
		myname++;
	else	myname = argv[0];

	if ((tty_fd = open("/dev/tty", O_RDWR)) < 0)
		SYS_ERROR("Opening: /dev/tty");
	
	if(!strcmp(myname, "kdtext")) {
		if (ioctl(tty_fd, KDSETMODE, KD_TEXT) != 0)
			SYS_ERROR("Setmode TEXT");
	} else {
		if (ioctl(tty_fd, KDSETMODE, KD_GRAPHICS) != 0)
			SYS_ERROR("Setmode GRAPHICS");
	}
	return 0;
}
