/*
 * This file is part of fb, the frame buffer device, a grafics card driver for
 *                                linux.
 *
 *     Copyright (C) 1995 Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Dipl.-Ing. Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 */

/* vga.h */

#ifndef SVGAFB_VGA_H
#define SVGAFB_VGA_H

#include "vga_regs.h"

/* defines */
#define VGA_PHYS_BASE	(0xA0000UL)

/* types */
struct vga_regs_s {
	unsigned char crt[CRT_C];
	unsigned char att[ATT_C];
	unsigned char gra[GRA_C];
	unsigned char seq[SEQ_C];
	unsigned char misc;
};

/* variables */
extern struct vga_regs_s vga_regs_640x350x16;

/* color / mono ? */
extern int CRT_I;		/* current CRT index register address */
extern int CRT_D;		/* current CRT data register address */
extern int IS1_R;		/* current input status register addres */
extern int FCR_W;		/* current Feature Control Register WRITE */

/* prototypes */

/* vga.c */
extern void vga_screenoff(void);
extern void vga_screenon(void);

extern void vga_savetextfontdata(void *buf);
extern void vga_restoretextfontdata(void *buf);

extern int vga_savepalette_getsize(void);
extern int vga_savepalette(unsigned char *r, unsigned char *g, unsigned char *b);
extern void vga_restorepalette(unsigned char *r, unsigned char *g, unsigned char *b);

extern int vga_saveregs_getsize(void);
extern int vga_saveregs(struct vga_regs_s *regs);
extern int vga_restoreregs(struct vga_regs_s *vregs);

extern void vga_color_mono(void);
extern void vga_init(void);
extern void vga_dumpregs(struct vga_regs_s *vregs);

#endif
