/*
 * This file is part of fb, the frame buffer device, a grafics card driver for
 *                                linux.
 *
 *     Copyright (C) 1995 Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Dipl.-Ing. Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 * Tiny changes by Michael Weller (eowmob@exp-math.uni-essen.de)
 */

#ifndef _FB_DEBUG_H
#define _FB_DEBUG_H

#ifdef DEBUG
#define DEB(__a) __a
#else
#define DEB(__a)
#endif

#define DOING    DEB(printk(KERN_DEBUG "%s: %s: doing %s.\n",	\
				FB_MODULE_NAME, __FILE__, __FUNCTION__);)
#define ENTERING DEB(printk(KERN_DEBUG "%s: %s: entering %s.\n",	\
				FB_MODULE_NAME, __FILE__, __FUNCTION__);)
#define LEAVING  DEB(printk(KERN_DEBUG "%s: %s: leaving %s.\n",	\
				FB_MODULE_NAME, __FILE__, __FUNCTION__);)

/* Check assertion except when in production code */
#ifdef NDEBUG
#define assert(expr, comment) (1)
#else
#define assert(expr, comment)  ((expr) ? 1 : \
	(printk(KERN_CRIT "%s:%u: failed assertion: %s\n", __FILE__, __LINE__, comment), \
		0))
#endif

#endif /* _FB_DEBUG_H */
