/*
 * This file is part of fb, the frame buffer device, a grafics card driver for
 *                                linux.
 *
 *     Copyright (C) 1995 Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Dipl.-Ing. Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 */

/* fb.h */

#ifndef FB_H
#define FB_H

#define FB_MODULE_NAME "fb"

/* interface of fb kernel module: types and ioctl values */

typedef struct {
	unsigned char driver_name[17];	/* 16 + \0 */
	unsigned char chipset_name[17];	/* 16 + \0 */
	unsigned char copyright[33];	/* 32 + \0 */
	unsigned char info[129];	/* 128 + \0 */
	unsigned long rev_major;
	unsigned long rev_minor;
	unsigned long rev_tiny;
	unsigned long totalmem;		/* total video mem */
	unsigned char memtype;		/* 0: DRAM, 1: VRAM */
	unsigned long number_modes;
	unsigned long default_mode;
} fb_info_t;

typedef struct {
	unsigned long num;		/* mode number */
	unsigned long xsize;		/* visible */
	unsigned long ysize;
	unsigned long xvirt;		/* virtual, available for panning */
	unsigned long yvirt;
	unsigned long xdim;		/* total screen size that can be */
	unsigned long ydim;		/* used and should be saved */
	unsigned long scanlinelength;	/* offset between scanlines */
	unsigned long vidmem;		/* usable video memory, rounded up, */
					/* including offscreen mem */
	unsigned long vidmem2mmap;	/* parameter for mmap(), rounded, */
					/* includes multiple mappings */
	unsigned long mmapmodel;	/* mmap model: */
					/* bit 0: r/w at base address */
					/* bit 1: r/o at base + vidmem */
					/* bit 2: w/o at base + 2*vidmem */
	unsigned long bitordering;	/* 01234567 (LSBFirst) or */
					/* 76543210 (MSBFirst)    */
	unsigned long byteordering;	/* 1234 (LSBFirst, Intel) or */
					/* 4321 (MSBFirst, Motorola) */
	unsigned long memorymodel;	/* ... */
	unsigned long numwindows;	/* number of banking windows */
	unsigned long windowsize;
	unsigned long windowshift;	/* log2(windowsize) */
	unsigned long numbanks;		/* number of banking possibilities, */
					/* including offscreen memory */
	unsigned long colormodel;	/* ... */
	unsigned long bpp;		/* e.g. 24 */
	unsigned long bpp_used;		/* e.g. 32 */
	unsigned long bitsRGB;		/* e.g. 6 or 8 */
	unsigned long sizered;
	unsigned long posred;
	unsigned long sizegreen;
	unsigned long posgreen;
	unsigned long sizeblue;
	unsigned long posblue;
	unsigned long sizeres;
	unsigned long posres;
	unsigned long black;		/* ? */
	unsigned long white;		/* ? */
	unsigned long pixelclock;
	unsigned long horizontalrefresh;
	unsigned long verticalfrequency;
} fb_mode_t;

typedef struct {
	unsigned long x;
	unsigned long y;
} fb_origin_t;

typedef struct {
	unsigned long first;
	unsigned long num;
	unsigned char *data;
} fb_cmap_t;

#include <sys/ioctl.h>

#define _FB_MAGIC               0x14

#define _FB_GETINFO		0x01

#define _FB_MODES_GET_INFO	0x10

#define _FB_MODE_SET		0x20

#define _FB_BLANK		0x30
#define _FB_UNBLANK		0x31

#define _FB_SET_ORIGIN		0x40

#define _FB_SET_COLORMAP	0x50
#define _FB_GET_COLORMAP	0x51

#define _FB_TEST_TEST		0x99

/* general infos */
#define FB_GETINFO		_IOR(_FB_MAGIC, _FB_GETINFO, fb_info_t)

#define FB_MODES_GET_INFO	_IOR(_FB_MAGIC, _FB_MODES_GET_INFO, fb_mode_t)

#define FB_MODE_SET		_IOW(_FB_MAGIC, _FB_MODE_SET, unsigned long)

#define FB_BLANK		_IO(_FB_MAGIC, _FB_BLANK)
#define FB_UNBLANK		_IO(_FB_MAGIC, _FB_UNBLANK)

#define FB_SET_ORIGIN		_IOW(_FB_MAGIC, _FB_SET_ORIGIN, fb_origin_t)

#define FB_SET_COLORMAP		_IOW(_FB_MAGIC, _FB_SET_COLORMAP, fb_cmap_t)
#define FB_GET_COLORMAP		_IOR(_FB_MAGIC, _FB_GET_COLORMAP, fb_cmap_t)

#define FB_TEST_TEST		_IO(_FB_MAGIC, _FB_TEST_TEST)

#endif
