/*
 * This file is part of fb, the frame buffer device, a grafics card driver for
 *                                linux.
 *
 *     Copyright (C) 1995 Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Dipl.-Ing. Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 */

/* et4000_m.h */

static fb_mode_t __chip_modesinfo[] = {
{
num:			0,
xsize:			1024,
ysize:			768,
xvirt:			1024,
yvirt:			768,
xdim:			1024,
ydim:			768,
scanlinelength:		1024,
vidmem:			1024*1024,
vidmem2mmap:		1024*1024,
mmapmodel:		1,
bitordering:		76543210,
byteordering:		1234,
memorymodel:		0,
numwindows:		1,
windowsize:		(1<<16),
windowshift:		16,
numbanks:		16,
colormodel:		0,
bpp:			8,
bpp_used:		8,
bitsRGB:		6,
sizered:		0,
posred:			0,
sizegreen:		0,
posgreen:		0,
sizeblue:		0,
posblue:		0,
sizeres:		0,
posres:			0,
black:			0,
white:			255,
pixelclock:		0,
horizontalrefresh:	0,
verticalfrequency:	0,
}
};

static struct chip_regs_s chip_regs_graph[] =
{
{	{ /* VGA */
	  /* 24xCRT */	{ 0x9B,0x7F,0x7F,0x9F,0x84,0x15,0x24,0xF5,0x00,0x60,0x00,0x00,
	  		  0x00,0x00,0x00,0x00,0x02,0x88,0xFF,0x80,0x60,0xFF,0x25,0xAB },
	  /* 21xATT */	{ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,
	  		  0x0C,0x0D,0x0E,0x0F,0x01,0x00,0x0F,0x00,0x00 },
	  /*  9xGRA */	{ 0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0F,0xFF },
	  /*  5xSEQ */	{ 0x03,0x01,0x0F,0x00,0x0E },
	  /*    MIS */	0xEF,
	},
	/* 8xCRT3x */	{ 0x00,0x00,0x20,0x00,0x08,0x00,0x43,0x1F },
	/* CRT3f */	0x00,
	/* SEQ07 */	0xBC,
	/* micro */	0x00,
	/* segsel */	0x00,
	/* ATT16 */	0x00
},
};
