%{
/*
 * This file is part of fb, the frame buffer device, a grafics card driver for
 *                                linux.
 *
 *      Copyright (C) 1995 Michael Weller (eowmob@exp-math.uni-essen.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Michael Weller (eowmob@exp-math.uni-essen.de or
 * mat42b@aixrs1.hrz.uni-essen.de) Heiderhoefen 116b,
 * D 46049 Oberhausen, Germany.
 */

#include "modecc.h"
#include "float.h"
%}

%union {
	int int_val;
	double float_val;
	}

%token TOK_ID TOK_PRINT TOK_HZ TOK_KHZ TOK_MHZ
%token<int_val> TOK_INT
%token<float_val> TOK_FLOAT

%right TOK_DEF
%left '^' '|'
%left '&'
%left TOK_SHL TOK_SHR
%left '+' '-'
%left '*' '/' '%'
%left NEG

%type<int_val> int 
%type<float_val> float

%%
source :	/* empty */
	|	source assignment ';'
	|	source TOK_PRINT printlist ';' { putchar('\n'); }
	|	source TOK_PRINT printlist ',' ';'
	|	source TOK_PRINT ';' { putchar('\n'); }
	|	source TOK_PRINT ',' ';'

printlist :	printelt
	|	printlist ',' { putchar(' '); } printelt

printelt :	int		{ printf("%d", $1); }
	|	float		{ printf("%g", $1); }

float: 		'(' float ')'	{ $$ = $2; }
	|	float '+' float	{ $$ = $1 + $3; }
	|	float '-' float	{ $$ = $1 - $3; }
	|	float '*' float	{ $$ = $1 * $3; }
	|	float '/' float	{ $$ = $1 / $3; }
	|	float '+' int	{ $$ = $1 + $3; }
	|	float '-' int	{ $$ = $1 - $3; }
	|	float '*' int	{ $$ = $1 * $3; }
	|	float '/' int	{ $$ = $1 / $3; }
	|	int '+' float	{ $$ = $1 + $3; }
	|	int '-' float	{ $$ = $1 - $3; }
	|	int '*' float	{ $$ = $1 * $3; }
	|	int '/' float	{ $$ = $1 / $3; }
	|	'-' float %prec NEG	{ $$ = - $2; }
	|	TOK_FLOAT		{ $$ = $1 }

int: 		'(' int ')'	{ $$ = $2; }
	|	int '+' int	{ $$ = $1 + $3; }
	|	int '-' int	{ $$ = $1 - $3; }
	|	int '*' int	{ $$ = $1 * $3; }
	|	int '/' int	{ $$ = $1 / $3; }
	|	int '%' int	{ $$ = $1 % $3; }
	|	int '^' int	{ $$ = $1 ^ $3; }
	|	int '&' int	{ $$ = $1 & $3; }
	|	int TOK_SHL int	{ $$ = $1 << $3; }
	|	int TOK_SHR int	{ $$ = $1 >> $3; }
	|	int '|' int	{ $$ = $1 | $3; }
	|	'~' int	%prec NEG	{ $$ = ~ $2; }
	|	'-' int %prec NEG	{ $$ = - $2; }
	|	TOK_INT		{ $$ = $1 }

assignment:	TOK_ID TOK_DEF int
%%
