%{
/*
 * This file is part of fb, the frame buffer device, a grafics card driver for
 *                                linux.
 *
 *      Copyright (C) 1995 Michael Weller (eowmob@exp-math.uni-essen.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Michael Weller (eowmob@exp-math.uni-essen.de or
 * mat42b@aixrs1.hrz.uni-essen.de) Heiderhoefen 116b,
 * D 46049 Oberhausen, Germany.
 */

#include "modepar.tab.h"
#include "modecc.h"
#include <ctype.h>
#include <string.h>

static int commstart, commnest;
static int srcalloc = 0;
static char backbuff[2][40] = {"", ""};
static int backtype[2] = {0, 0};
static int lastback = 0, numrets = 0;

#define RETURN(val) { \
	numrets++; \
	backtype[lastback] = val; \
	strncpy(backbuff[lastback], yytext, 35); \
	strcpy(backbuff[lastback]+35, "..."); \
	lastback ^= 1; \
	return val; \
}
/* Next rule was deleted, nested comments are nice but incompatible with cpp */
#if 0
<comment>"/*"				{commnest++;}
#endif
%}
%x comment 

DIGIT	[0-9]
ID	[a-z][a-z0-9_]*
WS	[\ \t\v\r\f]
DELIM	[\;\,\.\(\)\[\]\{\}]
OP	[\+\-\*\/\%\&\|\~]
%%
"/*"					{BEGIN(comment); commstart = srcline; commnest = 1;}
<comment>"/*"				{
					fprintf(stderr, ERRHEAD "%s, %d: Warning, /* in "
							"a /* */ comment!\n",
							source, commstart);
					}

<comment>[^*/\n]*\n			|
<comment>"*"+[^*/\n]*\n			srcline++;
<comment>"/"
<comment>[^*/\n]*
<comment>"*"+[^*/\n]*
<comment>"*"+"/"			{
					commnest--;
					if(!commnest)
						{BEGIN(INITIAL);}
					}
<comment><<EOF>>			{
					fprintf(stderr, ERRHEAD "%s, %d: unterminated "
							"outermost comment.\n",
							source, commstart);
					lexerr++;
					RETURN(0);
					}
{WS}*\n					srcline++;
{WS}+
^{WS}*"#"{WS}*"define"\n		|
^{WS}*"#"{WS}*"define"{WS}.*\n		|
^{WS}*"#"{WS}*"include"\n		|
^{WS}*"#"{WS}*"include"{WS}.*\n		|
^{WS}*"#"{WS}*"undef"\n			|
^{WS}*"#"{WS}*"undef"{WS}.*\n		|
^{WS}*"#"{WS}*"else"\n			|
^{WS}*"#"{WS}*"else"{WS}.*\n		|
^{WS}*"#"{WS}*"endif"\n			|
^{WS}*"#"{WS}*"endif"{WS}.*\n		|
^{WS}*"#"{WS}*"ifdef"\n			|
^{WS}*"#"{WS}*"ifdef"{WS}.*\n		|
^{WS}*"#"{WS}*"ifndef"\n		|
^{WS}*"#"{WS}*"ifndef"{WS}.*\n		|
^{WS}*"#"{WS}*"if"\n			|
^{WS}*"#"{WS}*"if"{WS}.*\n		{
					fprintf(stderr, ERRHEAD "%s, %d: Warning: spurious "
							"preprocessor statement encountered,\n"
							"\tuse --cpp flag!\n",
						source, srcline);
					srcline++;
					}
^{WS}*"#"{WS}*"line"{WS}+{DIGIT}+{WS}+\".*\"\n		|
^{WS}*"#"{WS}*"line"{WS}+{DIGIT}+{WS}+\".*\"{WS}.*\n	|
^{WS}*"#"{WS}*{DIGIT}+{WS}+\".*\"\n			|
^{WS}*"#"{WS}*{DIGIT}+{WS}+\".*\"{WS}.*\n		{
				{
				char *ptr = yytext, *ptd;

				while(!isdigit(*ptr))ptr++;
				sscanf(ptr, "%d", &srcline);
				while(*ptr != '"')ptr++;
				ptr++;
				if (srcalloc < strlen(ptr))
					source = malloc(srcalloc = strlen(ptr) + 20);
				if(!source) {
					fprintf(stderr, ERRHEAD "out of memory\n");
					exit(1);
				}
				ptd = source;
				while(*ptr != '"')
					*ptd++ = *ptr++;
				*ptd = 0;
				} }
"!".*\n					|
"#".*\n					|
"//".*\n				srcline++;
<<EOF>>				{RETURN(0)}
{DIGIT}+			{yylval.int_val = atoi(yytext); RETURN(TOK_INT)}
{DIGIT}+\.?{DIGIT}*e[+-]?{DIGIT}+	|
\.{DIGIT}+e[+-]?{DIGIT}+		|
{DIGIT}+\.{DIGIT}*			|
\.{DIGIT}+				{
					sscanf(yytext, "%lf", &yylval.float_val);
					RETURN(TOK_FLOAT)
					}
{OP}				{RETURN(yytext[0])}
{DELIM}				{RETURN(yytext[0])}
":="				{RETURN(TOK_DEF)}
"<<"				{RETURN(TOK_SHL)}
">>"				{RETURN(TOK_SHR)}
"print"				{RETURN(TOK_PRINT)}
"hz"				{RETURN(TOK_HZ)}
"khz"				{RETURN(TOK_KHZ)}
"mhz"				{RETURN(TOK_MHZ)}
{ID}				{RETURN(TOK_ID)}
.				{
		if (!iscntrl(yytext[0]))
			fprintf(stderr, ERRHEAD "%s, %d: illegal character <%c> = 0x%x = 0%o.\n",
				source, srcline, yytext[0], yytext[0], yytext[0]);
		else
			fprintf(stderr, ERRHEAD "%s, %d: illegal character 0x%x = 0%o.\n",
				source, srcline, yytext[0], yytext[0]);
		lexerr++;
  				}

%%

int yyerror(char *ptr) {
	fprintf(stderr, ERRHEAD "%s, %d: %s at \"", source, srcline, ptr);
	if (backtype[lastback ^ 1]) {
		fputs(backbuff[lastback ^ 1], stderr);
		if (numrets > 1) {
			if (backtype[lastback])
				fprintf(stderr, " %s", backbuff[lastback]);
			else fputs(" <EOF>", stderr);
		}
	} else	fputs("<EOF>", stderr);
	fputs("\".\n", stderr);
	lexerr++;
	return 0;
}

int yywrap() {
	return 1;
}
