# Makefile.inc for svga framebuffer module

CC		= gcc
CPP		= `gcc -print-libgcc-file-name | sed 's/libgcc.a/cpp/'` -P
CWARNFLAGS	= -Wall -Wstrict-prototypes -Wpointer-arith
CDEBUGFLAGS	= -DDEBUG -g


COPTFLAGS	= -O6 -fomit-frame-pointer

INCLUDES	= -I../module -I../include
CFLAGS		= $(CWARNFLAGS) $(COPTFLAGS) $(INCLUDES)
AR		= ar
ARFLAGS		= rcs
YACC            = bison -y

# I really suggest using -8!
LEX             = flex -8

# You may need some libs for your lex. either -lfl or -ll
# Usually you will just use my precompiled code and thus not need any.
#LEXLIB          = -lfl

.SUFFIXES:	.i

%.i:		%.c
		$(CC) -E $(CFLAGS) $< > $@
