#ifndef _SCANNER_H
#define _SCANNER_H

/*
 *  Copyright (c) Thomas Faehnle 1994  (Thomas.Faehnle@student.uni-ulm.de)
 *  Copyright (c) Andreas Beck   1994  (becka@hp.rz.uni-duesseldorf.de)
 *
 *  scanner.h,v 1.4 1994/04/13 21:23:40 blurf Exp
 */


struct modeinfo_struct {
  int xdpi,ydpi;		/* resolution */
  int sc_mode;
  int depth;			/* number of different colors (-1) */
  int bpl;			/* bytes per scanline */
  int left,right;		/* margins in Pixels */
  int top,bottom;		/* margins in Lines */
  int bright;		        /* brightness */
  int contrast;		        /* contrast */
  int hue;		        /* hue */
  int sat;		        /* saturation */
  int options;			/* enabled options */
};

#define SCM_UNKNOWN 0		/* Scanner modes : */
#define SCM_MONO 1		/* 1 BitPerPixel   */
#define SCM_GREY 2		/* 8 BitsPerPixel  */
#define SCM_TRUE 3		/* 24 Bit RGB      */

struct registers_struct {
  int regnum;			/* relative Register index */
  unsigned char data;		/* data read/written */
};  

struct scanner_type {
  char manufacturer[20],model[20];
};

#define SCC_SOFTSELECT	0x0001	/* Option is selectable by software */
#define SCC_SOFTDETECT	0x0002	/* Option is detectable by software */
#define SCC_HARDSWITCH	0x0004	/* Option is a hardware switch (requires 
				   user-interaction */
#define SCC_EMULATE	0x0008  /* Option is emulated by driver */
#define SCC_CANDO	0x000f  /* driver supports option,if any of the
				   above is set */	

struct minmax {int min,max;};

struct scanner_capabilities {

	int o_scm_mono;		/* Options for monochrome mode */
	int o_scm_grey;		/* Options for greyscale  mode */
	int o_scm_true;		/* Options for true-color mode */

	int o_xdpi;		/* Options for x resolution */
	int o_ydpi;		/* Options for y resolution */

	int o_bright;		/* Options for brightness */
	struct minmax bright;
	int o_contrast;		/* Options for contrast */
	struct minmax contrast;
	int o_hue;		/* Options for hue */
	struct minmax hue;
	int o_sat;		/* Options for saturation */
	struct minmax sat;

	int phys_width;		/* Width in mm */
	int phys_length;	/* Length in mm */

	int av_options;		/* Number of available Options (0-32) */

};

struct scanner_option {int  options;	/* Option availability */
                       char name[20];};
                       
					/* magic ioctl numbers */
#define HSIOCGOPT		0x73e7	/* Get option descriptions */
#define HSIOCGSCC		0x73e8  /* Get Scanner Capabilities */
#define HSIOCGSCT		0x73e9	/* Get Scanner Type */
#define HSIOCGMOD               0x73ea  /* Get modeinfo */
#define HSIOCSMOD		0x73eb  /* Set modeinfo */
#define HSIOCGREG		0x73ec	/* play with strange registers */ 
#define HSIOCSREG		0x73ef
#define HSIOCGBUF		0x73f0	/* get/set current buffer size (scanlines) */
#define HSIOCSBUF		0x73f1
#define HSIOCSSTH		0x73f2  /* get/set select(2) threshold (scanlines) */
#define HSIOCGSTH		0x73f3
#define HSIOCGSIB		0x73f4	/* get scanlines in buffer */

#endif /* _SCANNER_H */
