/*
 * sigaction.c.2
 *
 * Launch this program and then issue kill -<signo> <pid>.  I run through
 * all of the signals from 1 - 31.  Signals 5 (SIGTRAP) and 9 (SIGKILL)
 * terminate the process because they can not be handled.  Signal 26
 * is ignored completely because the thread's runtime won't let any
 * one mess with SIGVTALRM.  Signals #17 (SIGCHLD) and #18 (SIGCONT)
 * are not delivered to the process.
 *
 * Also, try this one:  Start up the process then send it a SIGSTOP (#19).
 * Next send it a SIGINT (#2).  Nothing should happen because the process
 * is asleep.  Next, issue a SIGCONT (#18).  Notice that the SIGINT is
 * delivered upon wakeup from the suspended state.  Just as it's supposed
 * to be.
 */
#include <pthread.h>
#include <stdio.h>
#include "utils.h"

extern int getpid( void );

void
handler( int sig )
{
	pthread_lock_global_np();
	printf("Caught %d %s in handler!\n", sig, sys_signame[sig] );
	pthread_unlock_global_np();
}


int main( int argc, char *argv[] )
{
   struct sigaction act;
   struct timespec ts = { 1, 0 };
   int i, nreps = 20;

   printf("pid %d: ", getpid()); fflush( NULL );
   for(i = 1; i < NSIG; i++ )
   {
	   act.sa_handler = handler;
	   act.sa_mask = (SA_RESTART);
	   sigemptyset( &act.sa_mask );
	   pthread_sigaction_np( i, &act, NULL );
   }

   /*
    * Sleep for 0.5 seconds, wake-up, then go back to sleep.  Do this
	* 5 times or until the process takes a kill -9.
    */
   while( nreps > 0 )
   {
	   pthread_delay_np( &ts );
	   nreps -= 1;
	   printf("."); fflush(NULL);
   }

   printf("   done\n");

   return(0);
}
