/*
 * exc_test.c
 */
#include <stdlib.h>
#include <stdio.h>
#include <pthread.h>
#include "exc_handling.h"

EXCEPTION MyExc;

static void 
foo( void )
{
   RAISE( MyExc );
}

void bar( void )
{
	TRY
		foo();
	CATCH_ALL
		pthread_lock_global_np();
	    printf("Child caught exception!\n");
	    pthread_unlock_global_np();
	ENDTRY

    pthread_exit( (void *)SUCCESS );
}
static pthread_t th;

int main()
{
   int st = 0, *p;

   EXCEPTION_INIT( MyExc );

   TRY
	   pthread_lock_global_np();
	   p = malloc( sizeof( p ));
       pthread_unlock_global_np();

       TRY

		    (void) pthread_create( &th, 
							       pthread_attr_default,
								   (pthread_startroutine_t) bar,
								   NULL );

           (void) pthread_join( th, (void **) &st );
           pthread_lock_global_np();
           fprintf( stderr, "child exited with %d status!\n", st );
           pthread_unlock_global_np();

       FINALLY

		   free( p );
           pthread_lock_global_np();
           fprintf( stderr, "Deallocated p\n");
           pthread_unlock_global_np();

       ENDTRY

   CATCH_ALL

	   pthread_lock_global_np();
       fprintf(stderr, "Caught an error!\n");
       pthread_unlock_global_np();

   ENDTRY

   return( EXIT_SUCCESS );
}

