.\" mkdble.8
.\" Copyright 1994 Jean-Marc Verbavatz
.\" Public Domain: may be redristributed freely
.TH MKDBLE 8 "27 June 1994" "Linux 1.1" "Linux Administration Manual"
.SH NAME
mkdble \- build a compressed special file
.SH SYNOPSIS
.B mkdble
.I special size 
.RI [ factor
.RI [ encoding
.RI [ block_size 
.RI [ cluster_size ]]]]
.SH DESCRIPTION
The
.B mkdble
command builds a compressed special device, or a file for use by the
"DouBle" on-the-fly block device compression driver.

.I special
is the name of either a block device, or a regular file that will 
be used by the driver for compressed data storage.
.B mkdble
will create the
.I special
file if necessary.

.I size
is the size in kilobytes of the
.I special
file.

.I factor
is the minimum expected average compression factor. This depends on the
compression algorithm
.RI ( encoding )
used and the type of data stored on the special file. Default is 2.0,
but values between 1.6 and 1.8 are usually more reasonable. The behaviour
of the compression driver will become unpredictable when the device is full.
Therefore, lower
.I factor
values are safer.

.I encoding
Is the default compression algorithm for the compressed device. In version
0.4:

.I   0
\- means no encoding (no compression)

.I   1
\- is a modified LZW algorithm

.I  10
\- is the predictor algorithm

.I 11
\- is the LZV algorithm (default)

.I 12
\- is the LZRW2 algorithm

.I 13
\- is the LZRW3A algorithm

In versions < 0.3, LZV, LZRW2 and LZRW3A used to have codes 102, 212 and
312 respectively. Versions 0.3 and 0.4 are backward compatible, but do not use these
values unless you know what you're doing.

.I block_size
Is the size of blocks ( must be 2^n with n > 7 and n < 11). The best
compression is usually achieved with 256 bytes (n=8), the best speed
is obtained with 1024 bytes (n=10). Default is 512 bytes (n=9).

.I cluster_size
Is the size of clusters
.RI (n* block_size ,
but at most 10240 bytes). The best compression is usually achieved with
10240 bytes, but compression is faster with 4096 bytes. Default is currently
10240 bytes. There will be no compression unless
.I cluster_size
>= 
.RI 2* block_size .
.SH SEE ALSO
.BR dbck (8), dbmount (8), dbumount (8), dbmode (8)
.SH AUTHORS
Jean-Marc Verbavatz <jmv@achaz.saclay.cea.fr>

LZV was written by Hermann Vogt

LZRW* was written by Ross Williams

predictor was written by Dave Rand and last modified by Peter Trattler
.SH DISCLAIMER
All the compression algorithms are patented in some countries. For more
information, refer to the compression FAQ, posted regularly on
"comp.compression".
