.\" dbfrag.8
.\" Copyright 1994 Jean-Marc Verbavatz
.\" Public Domain: may be distributed freely
.TH DBFRAG 8 "20 November 1994" "Linux 1.1" "Linux Administration Manual"
.SH NAME
dbfrag \- check fragmentation of a "DouBle" compressed block device
.SH SYNOPSIS
.B dbfrag
[-v[v]]
.I special

.SH OPTIONS
\-v: more verbose

.SH DESCRIPTION
.B dbfrag
is used to check fragmentation on a compressed block device.
.I special
is a compressed block device or file, created by the
.B mkdble
command.

.B dbfrag
will report:

\- cluster fragmentation and average 1024-byte block gap between
clusters. This value is not as critical as the two others, but should be as
small as possible.

\- block fragmentation within clusters and average 1024-byte gap between blocks.
This value should be as small as possible...

\- Average cluster deviation, which measures the average distance between the
actual location of a cluster and its ideal position. This value is heavily
dependent on the difference between actual compression and the value given as
a argument to mkdble.

As far as performance goes, the most important value is, by far, block
fragmentation. Until version 0.4 of "DouBle", no effort had been made to
prevent fragmentation. Blocks were essentially allocated as close as possible
to the beginnning of the device.

In version 0.4a, block allocation has been changed in order for block layout
to follow cluster layout as closely as possible. This will probably result
in higher cluster fragmentation, but smaller block fragmentation and cluster
deviation - blocks should be allocated closer to where they should be, but
gaps between clusters will be more frequent. 

.SH BUGS

There is currently no defrag utility :( - dbfrag is only intended to see
fragmentation change with time and/or driver versions. Comments are welcome !

.SH SEE ALSO
.BR dbmount (8), dbumount (8), mkdble (8), dbck (8)
.SH AUTHORS
Jean-Marc Verbavatz <jmv@achaz.saclay.cea.fr>
