/*  double/dbstat.c     DouBle driver device access.	22 Jan 1994
 *
 *  Copyright (C) 1994 Jean-Marc Verbavatz  <verbavatz@dsvidf.cea.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <errno.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/double.h>

main(argc, argv)
int argc;
char **argv;
{
int fd;
int result;
struct db_stat dble_stat;

if(argc != 2 || (fd = open(argv[1], O_RDWR))<0) {
	if(errno) perror(argv[0]);
	usage(argv[0]);
}

if((result = ioctl(fd, DBLE_STAT, &dble_stat))) perror(argv[0]);
printf("block read requests: %ld\n", dble_stat.rphysical);
printf("block write requests: %ld\n", dble_stat.wphysical);
printf("clusters read: %ld\n", dble_stat.roblock);
printf("clusters written: %ld\n", dble_stat.woblock);
printf("cluster read requests: %ld\n", dble_stat.rvirtual);
printf("cluster write requests: %ld\n", dble_stat.wvirtual);
printf("blocks hits/nohits: %ld/%ld\n", dble_stat.ihit, dble_stat.inohit);
printf("clusters hits/nohits: %ld/%ld\n", dble_stat.ohit, dble_stat.onohit);
/*printf("\nSwap compression: %ld pages, %d blocks/page\n",
	dble_stat.swap_pages, dble_stat.swap_blocks/dble_stat.swap_pages);*/
close(fd);
}

usage(s)
char *s;
{
fprintf(stderr, "\nusage: %s /dev/double[0-7]\n", s);
fprintf(stderr, "\treports DouBle driver device access\n");
exit(-1);
}
