.\" dbmount.8
.\" Copyright 1994 Jean-Marc Verbavatz
.\" Public Domain: may be distributed freely
.TH DBMOUNT 8 "27 June 1994" "Linux 1.1" "Linux Administration Manual"
.SH NAME
dbmount, dbumount \- mount and dismount "DouBle" compressed block devices
.SH SYNOPSIS
.B dbmount
.I special double_dev

.B dbumount
.I special

.B dbumount
.I double_dev

.B mount
.RI [ options ]
-t 
.I dble special cdouble_dev

.B umount
.RI [ options ]
.I special

.B umount
.RI [ options ]
.I cdouble_dev

.SH DESCRIPTION
The
.B dbmount
and
.B mount
-t
.I dble
commands can be used to map a virtual
.I double_dev
(normally /dev/doubleN with major = 19 and minor = N for
.BR dbmount )
or 
.I cdouble_dev
(/dev/cdoubleN, with minor = 128+N for 
.BR mount )
block device where non compressed blocks can be accessed, to a 
.I special
device or file where data is compressed.

.B dbmount
takes no option. for
.B mount
options, refer to 
.BR mount (8).

The
.B dbumount
and
.B umount
commands release the virtual
.I double_dev 
(or 
.IR cdouble_dev )
block device from the
.I special
file.

.B dbumount
takes no option. for
.B umount
options, refer to 
.BR umount (8).

.SH NOTES
These utilities require the "DouBle" patches to be compiled in the Linux kernel.

.B umount
can only be used for a device mounted with the
.B mount
-t
.I dble
command and
.B dbumount
must be used for a device that has been mounted with the
.B dbmount
command.

.SH SEE ALSO
.BR mount (8), umount (8), mkdble (8), dbck (8), dbmode (8)

.SH BUGS
.BR dbmount ing
(read/write) a file which is located on a read-only filesystem may yield
unexpected results.

Files on filesystems that do not implement the bmap function call, such as
some MS-DOS filesystems, cannot be used with the "DouBle" compression driver.

.SH AUTHOR
Jean-Marc Verbavatz <verbavatz@dsvidf.cea.fr>, with the help of many people
