/*  double/dbmount.c	mount device/file on DouBle device  1 Jan 1994
 *
 *  Copyright (C) 1994 Jean-Marc Verbavatz  <verbavatz@dsvidf.cea.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <errno.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/double.h>

main(argc, argv)
int argc;
char **argv;
{
int fd, gd;

if(argc != 3 || (fd = open(argv[1], O_RDWR))<0
		|| (gd = open(argv[2], O_RDWR)) < 0) {
	if(errno) perror(argv[0]);
	usage(argv[0]);
}
if(ioctl(gd, DBLE_SET_FD, fd))
	if(errno) perror(argv[0]);
close(gd);
close(fd);
}

usage(s)
char *s;
{
fprintf(stderr, "\nusage: %s file/dev /dev/double[0-7]\n", s);
fprintf(stderr, "\tmount file/dev on DouBle device\n");
exit(-1);
}
