.\" dbmode.8
.\" Copyright 1994 Jean-Marc Verbavatz
.\" Public Domain: may be distributed freely
.TH DBMODE 8 "27 June 1994" "Linux 1.1" "Linux Administration Manual"
.SH NAME
dbmode \- change compression algorithm on a "DouBle" compressed block device
.SH SYNOPSIS
.B dbmode
.I -p special
.RI [ encoding ]

.B dbmode
.I /dev/doubleN
.RI [ encoding ]
.SH DESCRIPTION
.B dbmode
is used to check or change the default compression algorithm on a commpressed
block device.
.B dbmode
comes in two flavors.

In the first form (dbmode -p special), the
.I default
compression algorithm can be read or updated.
.I special
is a compressed block device or file, created by the
.B mkdble
command. Any change to the default algorithm becomes permanent and becomes
effective as soon as the device is next mounted.

In the second form, (dbmode /dev/doubleN) the current compression algorithm,
can be read/updated on a
.I mounted
compressed device. Any change to the current algorithm immediately overrides
the default value until the device is dismounted.

.SH OPTIONS
.TP
.I encoding
change default
.RI ( -p ),
or current compression algorithm for a compressed device to:

.B 0
\- no compression

.B 1
\- LZW algorithm

.B 10
\- predictor algorithm

.B 11
\- LZV algorithm.

.B 12
\- LZRW2 algorithm.

.B 13
\- LZRW3A algorithm.
 
.SH NOTES
The default algorithm should not be changed on a mounted device.

In versions < 0.3, LZV,LZRW2,LZRW3A used to have codes 102, 212 and 312
respectively. Version 0.3 is backward compatible with these values.
.SH SEE ALSO
.BR dbmount (8), dbumount (8), mkdble (8), dbck (8)
.SH AUTHORS
Jean-Marc Verbavatz <verbavatz@dsvidf.cea.fr>

LZV was written by Hermann Vogt

LZRW* was written by Ross Williams

predictor was written by Dave Rand and last modified by Peter Trattler
.SH DISCLAIMER
All the compression algorithms are patented in some countries. For more
information, refer to the compression FAQ, posted regularly on
"comp.compression".
