/* lastcomm.h */

/* Copyright (C) 1993 Free Software Foundation, Inc.

This file is part of the GNU Accounting Utilities

The GNU Accounting Utilities are free software; you can redistribute
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation; either version
2, or (at your option) any later version.

The GNU Accounting Utilities are distributed in the hope that they will
be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Accounting Utilities; see the file COPYING.  If
not, write to the Free Software Foundation, 675 Mass Ave, Cambridge,
MA 02139, USA.  */

#define BUFFERED_RECS 256	/* how many records we buffer on input */

#define DEV_NAME_LEN 8		/* length of device names */

#define DEV_TABLE_SIZE 51	/* hash table size for device list (prime) */

struct dev_entry {
  struct dev_entry *next;	/* gee, could it be a linked list? */
  char name[DEV_NAME_LEN];	/* name of the device */
  long type;			/* type number of this device */
};

struct dev_entry *dev_list[DEV_TABLE_SIZE];

void main (int, char *[]);
void give_usage (void);
void parse_entries (void);
void init_flags_and_data (void);
void setup_devices (void);
char *devname (long);
int get_entry (struct acct **);
char *uid_name (int);
int desired_entry (char *, char *, char *);

