/* ac.h */

/* Copyright (C) 1993 Free Software Foundation, Inc.

This file is part of the GNU Accounting Utilities

The GNU Accounting Utilities are free software; you can redistribute
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation; either version
2, or (at your option) any later version.

The GNU Accounting Utilities are distributed in the hope that they will
be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Accounting Utilities; see the file COPYING.  If
not, write to the Free Software Foundation, 675 Mass Ave, Cambridge,
MA 02139, USA.  */

/* define some data structures */

struct list_entry {
  struct list_entry *next;
  char ut_line[8];
  char ut_name[8];
  long time;
};

struct user_entry {
  struct user_entry *next;
  char name[8];
  long time;
};

/* static stuff */

static char *months[] = {
  "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
  "Aug", "Sep", "Oct", "Nov", "Dec"
};

/* prototypes */

void main (int, char *[]);
void give_usage (void);
void init_flags_and_data (void);
void do_statistics (char *);
void log_in (struct utmp *);
void update_user_time (char *, long, char *);
void log_out (struct utmp *);
void log_everyone_out (long, int, int, char *);
void parse_entries (void);
void do_totals (long *, long *, int);
void update_system_time (long);
long midnight_before_me (long *);
long midnight_after_me (long *);
