/* Filename:	u2dtxt.c
   Version:	0.1
   Author:	Dave Hudson
   Originated:	16th December 1993 (DOS version started 16th July 1991)
   Last update:	16th December 1993

   Function:	Convert UNIX format text files to DOS format.  The difference
		is that the UNIX files only have a LF to terminate a line,
		whereas DOS uses CR LF. */


/* Include the standard libraries */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


/* Do the main thing!  If there are any problems exit with an errorlevel set */

void
main( int argc, char **argv )
{
  FILE *in_file, *out_file, *tmp_file;
  char tmp_str[256];
  int in_char;

  printf ("%s v0.1 file conversion utility (16th December 1993)\n", argv[0]);
  
  if (argc == 2) {
    strcpy (tmp_str, argv[1]);
    strcat (tmp_str, ".cvt");
    if ((tmp_file = fopen (tmp_str, "rb")) != NULL ) {
      fclose (tmp_file);
      fprintf (stderr, "Temporary output file already exists\n");
      exit (1);
    }
  } else if (argc == 3) {
    strcpy (tmp_str, argv[2]);
  } else {
    fprintf (stderr, "Usage: u2dtxt input-file [output-file]\n\n");
    exit (1);
  }

  if ((in_file = fopen (argv[1], "rb")) == NULL) {
    fprintf (stderr, "Failed to open input file '%s'\n", argv[1]);
    exit (1);
  }

  if ((out_file = fopen (tmp_str, "wb")) == NULL) {
    fprintf (stderr, "Failed to open output file '%s'\n", tmp_str);
    exit (1);
  }
    
  do {
    in_char = fgetc (in_file);
    if (in_char != EOF) {
      if (in_char == '\n')
	fputc ('\r', out_file);
      fputc (in_char, out_file);
    }
  } while (in_char != EOF);
  
  fclose (out_file);
  fclose (in_file);

  if (argc == 2) {
    if ((in_file = fopen (tmp_str, "rb")) == NULL) {
      fprintf (stderr, "Failed to open input file '%s'\n", tmp_str);
      exit (1);
    }
    
    if ((out_file = fopen (argv[1], "wb")) == NULL) {
      fclose (in_file);
      unlink (tmp_str);
      fprintf (stderr, "Failed to open output file '%s'\n", argv[1]);
      exit (1);
    }
    
    do {
      in_char = fgetc (in_file);
      if (in_char != EOF)
	fputc (in_char, out_file);
    } while (in_char != EOF);

    fclose (out_file);
    fclose (in_file);

    unlink (tmp_str);
  }

}


/* That's All Folks! */
