/*
 * Copyright (c) 1990-1993 Michael A. Cooper.
 * This software may be freely distributed provided it is not sold for 
 * profit and the author is credited appropriately.
 */

/*
 * $Id: qterm.h,v 6.3 1993/05/11 19:27:43 mcooper Exp mcooper $
 */

#ifndef __qterm_h__
#define __qterm_h__

#ifndef TABFILE
# define TABFILE	"/usr/local/lib/qtermtab" /* Default qtermtab file */
#endif
#define USRFILE		".qtermtab"		/* User's qtermtab file */
#define OLDUSRFILE	".qterm"		/* Old user qtermtab file */
#define ALTSEND		"\033[c"		/* Alternate query string */
#define TIMEOUT		4			/* Timeout (in seconds) */
#define RECVSIZE	512			/* Receive buffer size */
#define CHAR_MASK	0377			/* Character mask */
#define ESC		'\033'			/* ESCAPE */
#define SYSERR		SysErr()		/* System Error string */
#define A(s)		((s) ? s : "<none>")

/*
 * Table keywords
 */
#define K_PRIMARY	"primary"
#define K_SECONDARY	"secondary"
#define K_COMSEQ	"comseq"

/*
 * Table field types
 */
#define ET_PRIMARY	1			/* Primary entry */
#define ET_SECONDARY	2			/* Secondary entry */
#define ET_OLDSTYLE	3			/* Old style entry */

/*
 * Make sure we know what truth is
 */
#ifdef TRUE
#undef TRUE
#endif
#ifdef FALSE
#undef FALSE
#endif
#define TRUE		1
#define FALSE		0

/*
 * Terminal table structure
 */
struct termtable {
    int			qt_etype;	/* Entry type */
    char	       *qt_sendstr;	/* String to send to terminal */
    char	       *qt_recvstr;	/* String expected in response */
    char	       *qt_termname;	/* Generic Terminal name */
    char	       *qt_ntermname;	/* Next Terminal name */
    char	       *qt_fullname;	/* Full terminal name & description */
    struct termtable   *nxt;		/* Next structure */
};

/*
 * Declarations
 */
char		       *Decode();
char		       *StrCopy();
char		       *SysErr();
char		       *getenv();
char		       *strerror();
char		       *xmalloc();
extern char	       *ProgName;
extern char	       *TermFile;
extern char	       *strcpy();
extern int		Debug;
extern int		DoSysTabFile;
extern int		DoUsrTabFile;
extern int		UseAltStr;
void			AlarmOn();
void			AlarmOff();
void			Done();
void			MakeTable();
void			SetupSignals();

#if 	ARG_TYPE == ARG_STDARGS
void			Error(char *fmt, ...);
#else
void			Error();
#endif	/* ARG_STDARG */

#endif	/* __qterm_h__ */
